/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public abstract class AbstractShadowRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String schemaName, T config) {
        this.checkShadowRuleConfiguration(config);
    }

    protected abstract void checkShadowRuleConfiguration(T var1);

    protected void sizeCheck(Map<String, ShadowDataSourceConfiguration> dataSources, Map<String, ShadowTableConfiguration> shadowTables, String defaultShadowAlgorithmName) {
        Preconditions.checkState((!dataSources.isEmpty() ? 1 : 0) != 0, (Object)"No available shadow data sources mappings in shadow configuration.");
        if (null == defaultShadowAlgorithmName) {
            Preconditions.checkState((!shadowTables.isEmpty() ? 1 : 0) != 0, (Object)"No available shadow tables in shadow configuration.");
        }
    }

    protected void shadowAlgorithmsSizeCheck(Map<String, ShadowAlgorithm> shadowAlgorithms) {
        Preconditions.checkState((!shadowAlgorithms.isEmpty() ? 1 : 0) != 0, (Object)"No available shadow algorithms in shadow configuration.");
    }

    protected void shadowAlgorithmConfigurationsSizeCheck(Map<String, ShardingSphereAlgorithmConfiguration> shadowAlgorithmConfigurations) {
        Preconditions.checkState((!shadowAlgorithmConfigurations.isEmpty() ? 1 : 0) != 0, (Object)"No available shadow data algorithms in shadow configuration.");
    }

    protected void shadowTableDataSourcesAutoReferences(Map<String, ShadowTableConfiguration> shadowTables, Map<String, ShadowDataSourceConfiguration> dataSources) {
        if (1 == dataSources.size()) {
            String dataSourceName = dataSources.keySet().iterator().next();
            shadowTables.values().stream().map(ShadowTableConfiguration::getDataSourceNames).filter(Collection::isEmpty).forEach(dataSourceNames -> dataSourceNames.add(dataSourceName));
        }
    }

    protected void shadowTableDataSourcesReferencesCheck(Map<String, ShadowTableConfiguration> shadowTables, Map<String, ShadowDataSourceConfiguration> dataSources) {
        Set<String> dataSourceNames = dataSources.keySet();
        shadowTables.forEach((key, value) -> {
            for (String each : value.getDataSourceNames()) {
                Preconditions.checkState((boolean)dataSourceNames.contains(each), (String)"No available shadow data sources mappings in shadow table `%s`.", (Object)key);
            }
        });
    }

    protected void defaultShadowAlgorithmConfigurationCheck(String defaultShadowAlgorithmName, Map<String, ShardingSphereAlgorithmConfiguration> shadowAlgorithmConfigurations) {
        if (null != defaultShadowAlgorithmName) {
            ShardingSphereAlgorithmConfiguration shardingSphereAlgorithmConfiguration = shadowAlgorithmConfigurations.get(defaultShadowAlgorithmName);
            boolean state = null != shardingSphereAlgorithmConfiguration && "SIMPLE_HINT".equals(shardingSphereAlgorithmConfiguration.getType());
            Preconditions.checkState((boolean)state, (Object)"Default shadow algorithm class should be implement HintShadowAlgorithm.");
        }
    }

    protected void defaultShadowAlgorithmCheck(String defaultShadowAlgorithmName, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        if (null != defaultShadowAlgorithmName) {
            boolean isHintShadowAlgorithmState = shadowAlgorithms.get(defaultShadowAlgorithmName) instanceof HintShadowAlgorithm;
            Preconditions.checkState((boolean)isHintShadowAlgorithmState, (Object)"Default shadow algorithm class should be implement HintShadowAlgorithm.");
        }
    }

    protected void shadowTableAlgorithmsAutoReferences(Map<String, ShadowTableConfiguration> shadowTables, Set<String> shadowAlgorithmNames, String defaultShadowAlgorithmName) {
        for (Map.Entry<String, ShadowTableConfiguration> entry : shadowTables.entrySet()) {
            Collection names = entry.getValue().getShadowAlgorithmNames();
            names.removeIf(next -> !shadowAlgorithmNames.contains(next));
            if (null == defaultShadowAlgorithmName || !names.isEmpty()) continue;
            names.add(defaultShadowAlgorithmName);
        }
    }

    protected void shadowTableAlgorithmsReferencesCheck(Map<String, ShadowTableConfiguration> shadowTables) {
        shadowTables.forEach((key, value) -> Preconditions.checkState((!value.getShadowAlgorithmNames().isEmpty() ? 1 : 0) != 0, (String)"No available shadow Algorithm configuration in shadow table `%s`.", (Object)key));
    }
}

