/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.hint;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.shadow.algorithm.shadow.hint.ShadowHintExtractor;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.hint.PreciseHintShadowValue;

public final class SimpleHintShadowAlgorithm
implements HintShadowAlgorithm<String> {
    private Properties props = new Properties();

    public void init() {
        this.checkPropsSize();
    }

    private void checkPropsSize() {
        Preconditions.checkState((!this.props.isEmpty() ? 1 : 0) != 0, (Object)"Simple hint shadow algorithm props cannot be empty.");
    }

    public boolean isShadow(Collection<String> shadowTableNames, PreciseHintShadowValue<String> noteShadowValue) {
        if (ShadowOperationType.HINT_MATCH != noteShadowValue.getShadowOperationType() && !shadowTableNames.contains(noteShadowValue.getLogicTableName())) {
            return false;
        }
        Optional<Map<String, String>> noteOptional = ShadowHintExtractor.extractSimpleHint((String)((Object)noteShadowValue.getValue()));
        return noteOptional.filter(stringStringMap -> this.props.entrySet().stream().allMatch(entry -> Objects.equals(entry.getValue(), stringStringMap.get(String.valueOf(entry.getKey()))))).isPresent();
    }

    public String getType() {
        return "SIMPLE_HINT";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

