/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.hint;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class ShadowHintExtractor {
    private static final String SHADOW_HINT_SPACE = ",";
    private static final String SHADOW_HINT_ELEMENT_SPACE = ":";
    private static final String SQL_COMMENT_PREFIX = "/*";
    private static final String SQL_COMMENT_SUFFIX = "*/";
    private static final String SQL_COMMENT_TRACE_SPAN = "@TRACE_CONTEXT@";

    public static Optional<Map<String, String>> extractSimpleHint(String sqlComment) {
        String sqlCommentValue = ShadowHintExtractor.trim(sqlComment);
        if (ShadowHintExtractor.isBlank(sqlCommentValue)) {
            return Optional.empty();
        }
        return ShadowHintExtractor.extractElements(sqlCommentValue);
    }

    private static String trim(String sqlComment) {
        String result = sqlComment.trim();
        if (result.startsWith(SQL_COMMENT_PREFIX)) {
            result = ShadowHintExtractor.removePrefix(result);
        }
        if (result.endsWith(SQL_COMMENT_SUFFIX)) {
            result = ShadowHintExtractor.removeSuffix(result);
        }
        result = result.trim();
        return ShadowHintExtractor.trimTrace(result);
    }

    private static String removePrefix(String input) {
        return input.substring(SQL_COMMENT_PREFIX.length());
    }

    private static String removeSuffix(String input) {
        return input.substring(0, input.length() - SQL_COMMENT_SUFFIX.length());
    }

    private static String trimTrace(String sqlComment) {
        int startIndex = sqlComment.indexOf(SQL_COMMENT_TRACE_SPAN);
        if (startIndex == -1) {
            return sqlComment;
        }
        int traceLen = SQL_COMMENT_TRACE_SPAN.length();
        int fromIndex = startIndex + traceLen;
        int endIndex = sqlComment.indexOf(SQL_COMMENT_TRACE_SPAN, fromIndex);
        if (endIndex == -1) {
            return sqlComment;
        }
        String result = sqlComment.substring(0, startIndex) + sqlComment.substring(endIndex + traceLen);
        return result.trim();
    }

    private static Optional<Map<String, String>> extractElements(String sqlComment) {
        String[] noteElements = sqlComment.split(SHADOW_HINT_SPACE);
        HashMap<String, String> result = new HashMap<String, String>(noteElements.length);
        String[] stringArray = noteElements;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String each;
            String temp = each = stringArray[i];
            String[] split = (temp = temp.trim()).split(SHADOW_HINT_ELEMENT_SPACE);
            if (2 != split.length) continue;
            result.put(split[0].trim(), split[1].trim());
        }
        return Optional.of(result);
    }

    private static boolean isBlank(String noteValue) {
        int strLen;
        int n = strLen = noteValue == null ? 0 : noteValue.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(noteValue.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Generated
    private ShadowHintExtractor() {
    }
}

