/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.shadow.algorithm.shadow.validator.ShadowValueValidator;
import org.apache.shardingsphere.shadow.algorithm.shadow.validator.column.ShadowDateValueValidator;
import org.apache.shardingsphere.shadow.algorithm.shadow.validator.column.ShadowEnumValueValidator;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.column.PreciseColumnShadowValue;

public abstract class AbstractColumnMatchShadowAlgorithm
implements ColumnShadowAlgorithm<Comparable<?>> {
    private static final String COLUMN_PROPS_KEY = "column";
    private static final String OPERATION_PROPS_KEY = "operation";
    private static final Collection<ShadowValueValidator> SHADOW_VALUE_VALIDATORS = new LinkedList<ShadowValueValidator>();
    private Properties props = new Properties();
    private ShadowOperationType shadowOperationType;

    public boolean isShadow(PreciseColumnShadowValue<Comparable<?>> shadowValue) {
        String table = shadowValue.getLogicTableName();
        String column = shadowValue.getColumnName();
        Comparable value = shadowValue.getValue();
        if (this.shadowOperationType == shadowValue.getShadowOperationType() && String.valueOf(this.props.get(COLUMN_PROPS_KEY)).equals(column)) {
            SHADOW_VALUE_VALIDATORS.forEach(each -> each.preValidate(table, column, value));
            return this.isMatchValue(value);
        }
        return false;
    }

    public void init() {
        this.checkColumn();
        this.checkOperation();
        this.checkProps();
        this.initShadowValueValidator();
    }

    private void checkColumn() {
        Preconditions.checkNotNull((Object)this.props.get(COLUMN_PROPS_KEY), (Object)"Column shadow algorithm column cannot be null.");
    }

    private void checkOperation() {
        String operationType = String.valueOf(this.props.get(OPERATION_PROPS_KEY));
        Preconditions.checkNotNull((Object)operationType, (Object)"Column shadow algorithm operation cannot be null.");
        Optional shadowOperationType = ShadowOperationType.contains((String)operationType);
        Preconditions.checkState((boolean)shadowOperationType.isPresent(), (Object)"Column shadow algorithm operation must be one of [select, insert, update, delete].");
        this.shadowOperationType = (ShadowOperationType)shadowOperationType.get();
    }

    private void initShadowValueValidator() {
        SHADOW_VALUE_VALIDATORS.add(new ShadowDateValueValidator());
        SHADOW_VALUE_VALIDATORS.add(new ShadowEnumValueValidator());
    }

    protected abstract void checkProps();

    protected abstract boolean isMatchValue(Comparable<?> var1);

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

