/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.schedule.core.api;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContext;

public final class ModeScheduleContextFactory {
    private static final ModeScheduleContextFactory INSTANCE = new ModeScheduleContextFactory();
    private final Map<String, ModeScheduleContext> modeScheduleContexts = new ConcurrentHashMap<String, ModeScheduleContext>();

    public void init(String instanceId, ModeConfiguration modeConfig) {
        this.modeScheduleContexts.put(instanceId, new ModeScheduleContext(modeConfig));
    }

    public Optional<ModeScheduleContext> get() {
        if (this.modeScheduleContexts.values().isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.modeScheduleContexts.values().iterator().next());
    }

    public static ModeScheduleContextFactory getInstance() {
        return INSTANCE;
    }

    @Generated
    private ModeScheduleContextFactory() {
    }

    @Generated
    public Map<String, ModeScheduleContext> getModeScheduleContexts() {
        return this.modeScheduleContexts;
    }
}

