/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.schedule.core.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.schedule.CronJob;
import org.apache.shardingsphere.schedule.core.api.JobParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModeScheduleContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModeScheduleContext.class);
    private static final Map<String, ScheduleJobBootstrap> SCHEDULE_JOB_BOOTSTRAP_MAP = new HashMap<String, ScheduleJobBootstrap>(16, 1.0f);
    private final ModeConfiguration modeConfig;
    private final LazyInitializer<CoordinatorRegistryCenter> registryCenterLazyInitializer = new LazyInitializer<CoordinatorRegistryCenter>(){

        protected CoordinatorRegistryCenter initialize() {
            return ModeScheduleContext.this.initRegistryCenter(ModeScheduleContext.this.modeConfig);
        }
    };

    public ModeScheduleContext(ModeConfiguration modeConfig) {
        this.modeConfig = modeConfig;
    }

    private CoordinatorRegistryCenter initRegistryCenter(ModeConfiguration modeConfig) {
        String modeType;
        if (null == modeConfig) {
            return null;
        }
        switch (modeType = modeConfig.getType().toUpperCase()) {
            case "CLUSTER": {
                return this.initRegistryCenterForClusterMode(modeConfig);
            }
            case "STANDALONE": {
                return null;
            }
            case "MEMORY": {
                return null;
            }
        }
        log.warn("Unknown mode type '{}'", (Object)modeType);
        return null;
    }

    private CoordinatorRegistryCenter initRegistryCenterForClusterMode(ModeConfiguration modeConfig) {
        String clusterType = modeConfig.getRepository().getType();
        Properties props = modeConfig.getRepository().getProps();
        if ("ZooKeeper".equalsIgnoreCase(clusterType)) {
            ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(props.getProperty("server-lists"), props.getProperty("namespace"));
            ZookeeperRegistryCenter result = new ZookeeperRegistryCenter(zkConfig);
            result.init();
            return result;
        }
        log.warn("Unsupported clusterType '{}'", (Object)clusterType);
        return null;
    }

    private CoordinatorRegistryCenter getRegistryCenter() {
        return (CoordinatorRegistryCenter)this.registryCenterLazyInitializer.get();
    }

    public void startCronJob(CronJob job) {
        CoordinatorRegistryCenter registryCenter = this.getRegistryCenter();
        if (null == registryCenter) {
            log.warn("registryCenter is null, ignore, jobName={}, cron={}", (Object)job.getJobName(), (Object)job.getCron());
            return;
        }
        if (null != SCHEDULE_JOB_BOOTSTRAP_MAP.get(job.getJobName())) {
            SCHEDULE_JOB_BOOTSTRAP_MAP.get(job.getJobName()).shutdown();
        }
        JobConfiguration jobConfig = JobConfiguration.newBuilder((String)job.getJobName(), (int)1).cron(job.getCron()).overwrite(true).build();
        ScheduleJobBootstrap bootstrap = new ScheduleJobBootstrap(registryCenter, (ElasticJob)new ConsumerSimpleJob(job.getJob()), jobConfig);
        SCHEDULE_JOB_BOOTSTRAP_MAP.put(job.getJobName(), bootstrap);
        SCHEDULE_JOB_BOOTSTRAP_MAP.get(job.getJobName()).schedule();
    }

    private static final class ConsumerSimpleJob
    implements SimpleJob {
        private final Consumer<JobParameter> job;

        ConsumerSimpleJob(Consumer<JobParameter> job) {
            this.job = job;
        }

        public void execute(ShardingContext shardingContext) {
            this.job.accept(new JobParameter());
        }
    }
}

