/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.readwritesplitting.algorithm.DynamicReadwriteSplittingType;
import org.apache.shardingsphere.readwritesplitting.algorithm.config.AlgorithmProvidedReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.readwritesplitting.spi.ReadwriteSplittingType;
import org.apache.shardingsphere.readwritesplitting.spi.ReplicaLoadBalanceAlgorithm;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;

public final class ReadwriteSplittingRule
implements SchemaRule,
DataSourceContainedRule,
StatusContainedRule,
ExportableRule {
    private static final String DYNAMIC = "DYNAMIC";
    private static final String STATIC = "STATIC";
    private final Map<String, ReplicaLoadBalanceAlgorithm> loadBalancers = new LinkedHashMap<String, ReplicaLoadBalanceAlgorithm>();
    private final Map<String, ReadwriteSplittingDataSourceRule> dataSourceRules;

    public ReadwriteSplittingRule(ReadwriteSplittingRuleConfiguration ruleConfig) {
        Preconditions.checkArgument((!ruleConfig.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"Replica query data source rules can not be empty.");
        ruleConfig.getLoadBalancers().forEach((key, value) -> this.loadBalancers.put((String)key, (ReplicaLoadBalanceAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, ReplicaLoadBalanceAlgorithm.class)));
        this.dataSourceRules = new HashMap<String, ReadwriteSplittingDataSourceRule>(ruleConfig.getDataSources().size(), 1.0f);
        for (ReadwriteSplittingDataSourceRuleConfiguration each : ruleConfig.getDataSources()) {
            ReplicaLoadBalanceAlgorithm loadBalanceAlgorithm = Strings.isNullOrEmpty((String)each.getLoadBalancerName()) || !this.loadBalancers.containsKey(each.getLoadBalancerName()) ? (ReplicaLoadBalanceAlgorithm)RequiredSPIRegistry.getRegisteredService(ReplicaLoadBalanceAlgorithm.class) : this.loadBalancers.get(each.getLoadBalancerName());
            this.dataSourceRules.put(each.getName(), new ReadwriteSplittingDataSourceRule(each, loadBalanceAlgorithm));
        }
    }

    public ReadwriteSplittingRule(AlgorithmProvidedReadwriteSplittingRuleConfiguration ruleConfig) {
        Preconditions.checkArgument((!ruleConfig.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"Replica query data source rules can not be empty.");
        this.loadBalancers.putAll(ruleConfig.getLoadBalanceAlgorithms());
        this.dataSourceRules = new HashMap<String, ReadwriteSplittingDataSourceRule>(ruleConfig.getDataSources().size(), 1.0f);
        for (ReadwriteSplittingDataSourceRuleConfiguration each : ruleConfig.getDataSources()) {
            ReplicaLoadBalanceAlgorithm loadBalanceAlgorithm = Strings.isNullOrEmpty((String)each.getLoadBalancerName()) || !this.loadBalancers.containsKey(each.getLoadBalancerName()) ? (ReplicaLoadBalanceAlgorithm)RequiredSPIRegistry.getRegisteredService(ReplicaLoadBalanceAlgorithm.class) : this.loadBalancers.get(each.getLoadBalancerName());
            this.dataSourceRules.put(each.getName(), new ReadwriteSplittingDataSourceRule(each, loadBalanceAlgorithm));
        }
    }

    public ReadwriteSplittingDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<ReadwriteSplittingDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, ReadwriteSplittingDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.putAll(entry.getValue().getDataSourceMapper());
        }
        return result;
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        if (event instanceof DataSourceNameDisabledEvent) {
            for (Map.Entry<String, ReadwriteSplittingDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                entry.getValue().updateDisabledDataSourceNames(((DataSourceNameDisabledEvent)event).getQualifiedSchema().getDataSourceName(), ((DataSourceNameDisabledEvent)event).isDisabled());
            }
        }
    }

    public Map<String, Supplier<Object>> getExportedMethods() {
        HashMap<String, Supplier<Object>> result = new HashMap<String, Supplier<Object>>(4, 1.0f);
        result.put("auto_aware_data_source", () -> this.exportDataSource(false, DYNAMIC));
        result.put("auto_aware_data_source_name", this::exportAutoAwareDataSourceNames);
        result.put("enabled_data_source", () -> this.exportDataSource(true, STATIC));
        result.put("data_source", () -> this.exportDataSource(false, DYNAMIC, STATIC));
        return result;
    }

    private Map<String, Map<String, String>> exportDataSource(boolean removeDisabled, String ... readwriteSplittingTypes) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(this.dataSourceRules.size(), 1.0f);
        this.dataSourceRules.forEach((name, dataSourceRule) -> {
            Map<String, String> dataSources;
            if (Arrays.asList(readwriteSplittingTypes).contains(dataSourceRule.getReadwriteSplittingType().getType()) && !(dataSources = dataSourceRule.getDataSources(removeDisabled)).isEmpty()) {
                result.put(dataSourceRule.getName(), dataSources);
            }
        });
        return result;
    }

    private Collection<String> exportAutoAwareDataSourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ReadwriteSplittingDataSourceRule each : this.dataSourceRules.values()) {
            if (!(each.getReadwriteSplittingType() instanceof DynamicReadwriteSplittingType)) continue;
            result.add(((DynamicReadwriteSplittingType)each.getReadwriteSplittingType()).getAutoAwareDataSourceName());
        }
        return result;
    }

    public String getType() {
        return ReadwriteSplittingRule.class.getSimpleName();
    }

    static {
        ShardingSphereServiceLoader.register(ReplicaLoadBalanceAlgorithm.class);
        ShardingSphereServiceLoader.register(ReadwriteSplittingType.class);
    }
}

