/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.spi.ReadwriteSplittingType;
import org.apache.shardingsphere.readwritesplitting.spi.ReplicaLoadBalanceAlgorithm;

public final class ReadwriteSplittingDataSourceRule {
    private final String name;
    private final ReadwriteSplittingType readwriteSplittingType;
    private final ReplicaLoadBalanceAlgorithm loadBalancer;
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();

    public ReadwriteSplittingDataSourceRule(ReadwriteSplittingDataSourceRuleConfiguration config, ReplicaLoadBalanceAlgorithm loadBalancer) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getName()) ? 1 : 0) != 0, (Object)"Name is required.");
        this.name = config.getName();
        this.readwriteSplittingType = (ReadwriteSplittingType)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)new ShardingSphereAlgorithmConfiguration(config.getType(), config.getProps()), ReadwriteSplittingType.class);
        this.loadBalancer = loadBalancer;
    }

    public String getWriteDataSource() {
        return this.readwriteSplittingType.getWriteDataSource();
    }

    public List<String> getReadDataSourceNames() {
        return this.readwriteSplittingType.getReadDataSources().stream().filter(each -> !this.disabledDataSourceNames.contains(each)).collect(Collectors.toList());
    }

    public void updateDisabledDataSourceNames(String dataSourceName, boolean isDisabled) {
        if (isDisabled) {
            this.disabledDataSourceNames.add(dataSourceName);
        } else {
            this.disabledDataSourceNames.remove(dataSourceName);
        }
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        return this.readwriteSplittingType.getDataSourceMapper(this.name);
    }

    public Map<String, String> getDataSources(boolean removeDisabled) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.readwriteSplittingType.getDataSources().forEach((key, value) -> {
            if ("replica_data_source_names".equals(key) && removeDisabled) {
                value = this.removeDisabledDataSources((String)value);
            }
            result.put((String)key, (String)value);
        });
        return result;
    }

    private String removeDisabledDataSources(String readDataSources) {
        if (this.disabledDataSourceNames.isEmpty()) {
            return readDataSources;
        }
        LinkedList<String> dataSources = new LinkedList<String>(Splitter.on((String)",").trimResults().splitToList((CharSequence)readDataSources));
        dataSources.removeIf(this.disabledDataSourceNames::contains);
        return String.join((CharSequence)",", dataSources);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ReadwriteSplittingType getReadwriteSplittingType() {
        return this.readwriteSplittingType;
    }

    @Generated
    public ReplicaLoadBalanceAlgorithm getLoadBalancer() {
        return this.loadBalancer;
    }
}

