/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class SchemaMetaDataPersistService {
    private final PersistRepository repository;

    public void persist(String databaseName, String schemaName, ShardingSphereSchema schema) {
        if (null == schema) {
            return;
        }
        Optional<ShardingSphereSchema> originalSchema = this.load(databaseName, schemaName);
        if (originalSchema.isPresent()) {
            this.compareAndPersist(databaseName, schemaName, schema, originalSchema.get());
            return;
        }
        this.persistTables(databaseName, schemaName, schema.getTables());
    }

    public void persist(String schemaName, TableMetaData tableMetaData) {
        this.repository.persist(SchemaMetaDataNode.getTableMetaDataPath(schemaName, schemaName, tableMetaData.getName().toLowerCase()), YamlEngine.marshal((Object)new TableMetaDataYamlSwapper().swapToYamlConfiguration(tableMetaData)));
    }

    public void persist(String databaseName, String schemaName, TableMetaData tableMetaData) {
        this.repository.persist(SchemaMetaDataNode.getTableMetaDataPath(databaseName, schemaName, tableMetaData.getName().toLowerCase()), YamlEngine.marshal((Object)new TableMetaDataYamlSwapper().swapToYamlConfiguration(tableMetaData)));
    }

    public void persist(String schemaName) {
        this.repository.persist(SchemaMetaDataNode.getMetaDataTablesPath(schemaName, schemaName), "");
    }

    private void compareAndPersist(String databaseName, String schemaName, ShardingSphereSchema schema, ShardingSphereSchema originalSchema) {
        LinkedHashMap<String, TableMetaData> cachedLocalTables = new LinkedHashMap<String, TableMetaData>(schema.getTables());
        for (Map.Entry entry : originalSchema.getTables().entrySet()) {
            String onlineTableName = (String)entry.getKey();
            TableMetaData localTableMetaData = (TableMetaData)cachedLocalTables.remove(onlineTableName);
            if (null == localTableMetaData) {
                this.delete(databaseName, schemaName, onlineTableName);
                continue;
            }
            if (localTableMetaData.equals(entry.getValue())) continue;
            this.persist(databaseName, schemaName, localTableMetaData);
        }
        if (!cachedLocalTables.isEmpty()) {
            this.persistTables(databaseName, schemaName, cachedLocalTables);
        }
    }

    private void persistTables(String databaseName, String schemaName, Map<String, TableMetaData> tables) {
        tables.forEach((key, value) -> this.repository.persist(SchemaMetaDataNode.getTableMetaDataPath(databaseName, schemaName, key), YamlEngine.marshal((Object)new TableMetaDataYamlSwapper().swapToYamlConfiguration(value))));
    }

    public void delete(String schemaName) {
        this.repository.delete(SchemaMetaDataNode.getSchemaNamePath(schemaName));
    }

    public void delete(String schemaName, String tableName) {
        this.repository.delete(SchemaMetaDataNode.getTableMetaDataPath(schemaName, schemaName, tableName));
    }

    public void delete(String databaseName, String schemaName, String tableName) {
        this.repository.delete(SchemaMetaDataNode.getTableMetaDataPath(databaseName, schemaName, tableName));
    }

    public Optional<ShardingSphereSchema> load(String databaseName, String schemaName) {
        List<String> tables = this.repository.getChildrenKeys(SchemaMetaDataNode.getMetaDataTablesPath(databaseName, schemaName));
        if (tables.isEmpty()) {
            return Optional.empty();
        }
        ShardingSphereSchema schema = new ShardingSphereSchema();
        tables.forEach(each -> {
            String content = this.repository.get(SchemaMetaDataNode.getTableMetaDataPath(databaseName, schemaName, each));
            TableMetaData tableMetaData = new TableMetaDataYamlSwapper().swapToObject((YamlTableMetaData)YamlEngine.unmarshal((String)content, YamlTableMetaData.class));
            schema.getTables().put(each, tableMetaData);
        });
        return Optional.of(schema);
    }

    public Collection<String> loadAllNames() {
        return this.repository.getChildrenKeys(SchemaMetaDataNode.getMetaDataNodePath());
    }

    @Generated
    public SchemaMetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

