/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.memory.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.Generated;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;

public final class ShardingSphereNonReentrantLock
implements ShardingSphereLock {
    private static final long DEFAULT_TRY_LOCK_TIMEOUT_MILLISECONDS = 180000L;
    private final Lock innerLock;
    private volatile boolean locked;

    public boolean tryLock(String lockName) {
        return this.innerTryLock(180000L);
    }

    public boolean tryLock(String lockName, long timeout) {
        return this.innerTryLock(timeout);
    }

    private synchronized boolean innerTryLock(long timeout) {
        if (this.locked) {
            return false;
        }
        try {
            if (this.innerLock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                this.locked = true;
                return true;
            }
            return false;
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public synchronized void releaseLock(String lockName) {
        if (this.locked) {
            this.innerLock.unlock();
            this.locked = false;
        }
    }

    public boolean isLocked(String lockName) {
        return this.locked;
    }

    public long getDefaultTimeOut() {
        return 180000L;
    }

    @Generated
    public ShardingSphereNonReentrantLock(Lock innerLock) {
        this.innerLock = innerLock;
    }
}

