/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverExecutor;
import org.apache.shardingsphere.driver.executor.callback.ExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.ExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.callback.impl.StatementExecuteQueryCallback;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.driver.jdbc.exception.JDBCTransactionAcrossDatabasesException;
import org.apache.shardingsphere.driver.jdbc.exception.SQLExceptionErrorCode;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.decider.engine.SQLFederationDeciderEngine;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.RawExecutionRule;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.util.exception.sql.SQLWrapperException;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.traffic.engine.TrafficEngine;
import org.apache.shardingsphere.traffic.exception.EmptyTrafficExecutionUnitException;
import org.apache.shardingsphere.traffic.rule.TrafficRule;

public final class ShardingSphereStatement
extends AbstractStatementAdapter {
    private final ShardingSphereConnection connection;
    private final MetaDataContexts metaDataContexts;
    private final List<Statement> statements;
    private final StatementOption statementOption;
    private final DriverExecutor executor;
    private final KernelProcessor kernelProcessor;
    private final TrafficRule trafficRule;
    private final StatementManager statementManager;
    private final EventBusContext eventBusContext;
    private boolean returnGeneratedKeys;
    private ExecutionContext executionContext;
    private ResultSet currentResultSet;
    private String trafficInstanceId;
    private SQLFederationDeciderContext deciderContext;

    public ShardingSphereStatement(ShardingSphereConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.metaDataContexts = connection.getContextManager().getMetaDataContexts();
        this.eventBusContext = connection.getContextManager().getInstanceContext().getEventBusContext();
        this.statements = new LinkedList<Statement>();
        this.statementOption = new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.executor = new DriverExecutor(connection);
        this.kernelProcessor = new KernelProcessor();
        this.trafficRule = (TrafficRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(TrafficRule.class);
        this.statementManager = new StatementManager();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingSphereResultSet result;
        if (Strings.isNullOrEmpty((String)sql)) {
            SQLExceptionErrorCode errorCode = SQLExceptionErrorCode.SQL_STRING_NULL_OR_EMPTY;
            throw new SQLException(errorCode.getErrorMessage(), errorCode.getSqlState(), errorCode.getErrorCode());
        }
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.checkSameDatabaseNameInTransaction(queryContext.getSqlStatementContext(), this.connection.getDatabaseName());
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                ResultSet resultSet = (ResultSet)this.executor.getTrafficExecutor().execute(executionUnit, Statement::executeQuery);
                return resultSet;
            }
            this.deciderContext = ShardingSphereStatement.decide(queryContext, this.metaDataContexts.getMetaData().getProps(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()));
            if (this.deciderContext.isUseSQLFederation()) {
                ResultSet executionUnit = this.executeFederationQuery(queryContext);
                return executionUnit;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            List<QueryResult> queryResults = this.executeQuery0();
            MergedResult mergedResult = this.mergeQuery(queryResults);
            result = new ShardingSphereResultSet(this.getShardingSphereResultSets(), mergedResult, this, this.executionContext);
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    private static SQLFederationDeciderContext decide(QueryContext queryContext, ConfigurationProperties props, ShardingSphereDatabase database) {
        SQLFederationDeciderEngine deciderEngine = new SQLFederationDeciderEngine(database.getRuleMetaData().getRules(), props);
        return deciderEngine.decide(queryContext, database);
    }

    private Optional<String> getInstanceIdAndSet(QueryContext queryContext) {
        Optional<String> result = this.connection.getConnectionContext().getTrafficInstanceId();
        if (!result.isPresent()) {
            result = this.getInstanceId(queryContext);
        }
        if (this.connection.isHoldTransaction() && result.isPresent()) {
            this.connection.getConnectionContext().setTrafficInstanceId(result.get());
        }
        return result;
    }

    private Optional<String> getInstanceId(QueryContext queryContext) {
        InstanceContext instanceContext = this.connection.getContextManager().getInstanceContext();
        return null != this.trafficRule && !this.trafficRule.getStrategyRules().isEmpty() ? new TrafficEngine(this.trafficRule, instanceContext).dispatch(queryContext, this.connection.isHoldTransaction()) : Optional.empty();
    }

    private List<ResultSet> getShardingSphereResultSets() {
        return this.statements.stream().map(this::getResultSet).collect(Collectors.toList());
    }

    private List<QueryResult> executeQuery0() throws SQLException {
        if (this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
            return this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext)).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        }
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
        this.cacheStatements(executionGroupContext.getInputGroups());
        StatementExecuteQueryCallback callback = new StatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), this.executionContext.getSqlStatementContext().getSqlStatement(), SQLExecutorExceptionHandler.isExceptionThrown(), this.eventBusContext);
        return this.executor.getRegularExecutor().executeQuery(executionGroupContext, this.executionContext.getQueryContext(), callback);
    }

    private ResultSet executeFederationQuery(QueryContext queryContext) throws SQLException {
        StatementExecuteQueryCallback callback = new StatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), queryContext.getSqlStatementContext().getSqlStatement(), SQLExecutorExceptionHandler.isExceptionThrown(), this.eventBusContext);
        FederationContext context = new FederationContext(false, queryContext, this.metaDataContexts.getMetaData().getDatabases());
        return this.executor.getFederationExecutor().executeQuery(this.createDriverExecutionPrepareEngine(), (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine() {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (ExecutorConnectionManager)this.connection.getConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType());
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.checkSameDatabaseNameInTransaction(queryContext.getSqlStatementContext(), this.connection.getDatabaseName());
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                int n = (Integer)this.executor.getTrafficExecutor().execute(executionUnit, Statement::executeUpdate);
                return n;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int executionUnit = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext)));
                return executionUnit;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executeUpdate(executionGroupContext, (actualSQL, statement) -> statement.executeUpdate(actualSQL), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.checkSameDatabaseNameInTransaction(queryContext.getSqlStatementContext(), this.connection.getDatabaseName());
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                int n = (Integer)this.executor.getTrafficExecutor().execute(executionUnit, (statement, actualSQL) -> statement.executeUpdate(actualSQL, autoGeneratedKeys));
                return n;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int executionUnit = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext)));
                return executionUnit;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executeUpdate(executionGroupContext, (actualSQL, statement) -> statement.executeUpdate(actualSQL, autoGeneratedKeys), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.checkSameDatabaseNameInTransaction(queryContext.getSqlStatementContext(), this.connection.getDatabaseName());
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                int n = (Integer)this.executor.getTrafficExecutor().execute(executionUnit, (statement, actualSQL) -> statement.executeUpdate(actualSQL, columnIndexes));
                return n;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int executionUnit = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext)));
                return executionUnit;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroups = this.createExecutionContext();
            this.cacheStatements(executionGroups.getInputGroups());
            int n = this.executeUpdate(executionGroups, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnIndexes), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.checkSameDatabaseNameInTransaction(queryContext.getSqlStatementContext(), this.connection.getDatabaseName());
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                int n = (Integer)this.executor.getTrafficExecutor().execute(executionUnit, (statement, actualSQL) -> statement.executeUpdate(actualSQL, columnNames));
                return n;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int executionUnit = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext)));
                return executionUnit;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executeUpdate(executionGroupContext, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnNames), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private int executeUpdate(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, final ExecuteUpdateCallback updater, SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits) throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        JDBCExecutorCallback<Integer> callback = new JDBCExecutorCallback<Integer>(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), sqlStatementContext.getSqlStatement(), isExceptionThrown, this.eventBusContext){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return updater.executeUpdate(sql, statement);
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
        return this.executor.getRegularExecutor().executeUpdate(executionGroupContext, this.executionContext.getQueryContext(), routeUnits, callback);
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (1 == autoGeneratedKeys) {
                this.returnGeneratedKeys = true;
            }
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, autoGeneratedKeys));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.returnGeneratedKeys = true;
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnIndexes));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this.returnGeneratedKeys = true;
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnNames));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
    }

    private boolean execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, final ExecuteCallback executeCallback, SQLStatement sqlStatement, Collection<RouteUnit> routeUnits) throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        JDBCExecutorCallback<Boolean> jdbcExecutorCallback = new JDBCExecutorCallback<Boolean>(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), sqlStatement, isExceptionThrown, this.eventBusContext){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return executeCallback.execute(sql, statement);
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
        return this.executor.getRegularExecutor().execute(executionGroupContext, this.executionContext.getQueryContext(), routeUnits, jdbcExecutorCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute0(String sql, ExecuteCallback callback) throws SQLException {
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.checkSameDatabaseNameInTransaction(queryContext.getSqlStatementContext(), this.connection.getDatabaseName());
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                boolean bl = (Boolean)this.executor.getTrafficExecutor().execute(executionUnit, (statement, actualSQL) -> callback.execute(actualSQL, statement));
                return bl;
            }
            this.deciderContext = ShardingSphereStatement.decide(queryContext, this.metaDataContexts.getMetaData().getProps(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()));
            if (this.deciderContext.isUseSQLFederation()) {
                ResultSet resultSet = this.executeFederationQuery(queryContext);
                boolean bl = null != resultSet;
                return bl;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                List results = this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext));
                boolean bl = results.iterator().next() instanceof QueryResult;
                return bl;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            boolean bl = this.execute(executionGroupContext, callback, this.executionContext.getSqlStatementContext().getSqlStatement(), this.executionContext.getRouteContext().getRouteUnits());
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private void checkSameDatabaseNameInTransaction(SQLStatementContext<?> sqlStatementContext, String connectionDatabaseName) {
        if (!this.connection.getConnectionContext().getTransactionConnectionContext().isInTransaction()) {
            return;
        }
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().ifPresent(databaseName -> {
                if (!databaseName.equals(connectionDatabaseName)) {
                    throw new JDBCTransactionAcrossDatabasesException();
                }
            });
        }
    }

    private JDBCExecutionUnit createTrafficExecutionUnit(String trafficInstanceId, QueryContext queryContext) throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        ExecutionUnit executionUnit = new ExecutionUnit(trafficInstanceId, new SQLUnit(queryContext.getSql(), queryContext.getParameters()));
        ExecutionGroupContext context = prepareEngine.prepare(new RouteContext(), Collections.singletonList(executionUnit));
        return (JDBCExecutionUnit)context.getInputGroups().stream().flatMap(each -> each.getInputs().stream()).findFirst().orElseThrow(EmptyTrafficExecutionUnitException::new);
    }

    private void clearStatements() throws SQLException {
        for (Statement each : this.statements) {
            each.close();
        }
        this.statements.clear();
    }

    private QueryContext createQueryContext(String sql) {
        SQLParserRule sqlParserRule = (SQLParserRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(DatabaseTypeEngine.getTrunkDatabaseTypeName((DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType())).parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.metaDataContexts.getMetaData().getDatabases(), (SQLStatement)sqlStatement, (String)this.connection.getDatabaseName());
        return new QueryContext(sqlStatementContext, sql, Collections.emptyList());
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) throws SQLException {
        this.clearStatements();
        SQLCheckEngine.check((SQLStatementContext)queryContext.getSqlStatementContext(), (List)queryContext.getParameters(), (Collection)this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules(), (String)this.connection.getDatabaseName(), (Map)this.metaDataContexts.getMetaData().getDatabases(), null);
        return this.kernelProcessor.generateExecutionContext(queryContext, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps(), this.connection.getConnectionContext());
    }

    private ExecutionGroupContext<JDBCExecutionUnit> createExecutionContext() throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        return prepareEngine.prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionContext() throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules()).prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private void cacheStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> executionGroups) throws SQLException {
        for (ExecutionGroup<JDBCExecutionUnit> each : executionGroups) {
            this.statements.addAll(each.getInputs().stream().map(JDBCExecutionUnit::getStorageResource).collect(Collectors.toList()));
        }
        this.replay();
    }

    private void replay() throws SQLException {
        for (Statement each : this.statements) {
            this.getMethodInvocationRecorder().replay(each);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (null != this.trafficInstanceId) {
            return this.executor.getTrafficExecutor().getResultSet();
        }
        if (null != this.deciderContext && this.deciderContext.isUseSQLFederation()) {
            return this.executor.getFederationExecutor().getResultSet();
        }
        if (this.executionContext.getSqlStatementContext() instanceof SelectStatementContext || this.executionContext.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets();
            MergedResult mergedResult = this.mergeQuery(this.getQueryResults(resultSets));
            this.currentResultSet = new ShardingSphereResultSet(resultSets, mergedResult, this, this.executionContext);
        }
        return this.currentResultSet;
    }

    private ResultSet getResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    private List<ResultSet> getResultSets() throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (Statement each : this.statements) {
            result.add(each.getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    private MergedResult mergeQuery(List<QueryResult> queryResults) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()), this.metaDataContexts.getMetaData().getProps(), this.connection.getConnectionContext());
        return mergeEngine.merge(queryResults, this.executionContext.getSqlStatementContext());
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        return this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).isNeedAccumulate(this.executionContext.getSqlStatementContext().getTablesContext().getTableNames()));
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent() && !generatedKey.get().getGeneratedValues().isEmpty()) {
            return new GeneratedKeysResultSet(generatedKey.get().getColumnName(), generatedKey.get().getGeneratedValues().iterator(), this);
        }
        LinkedList<Comparable> generatedValues = new LinkedList<Comparable>();
        for (Statement each : this.statements) {
            ResultSet resultSet = each.getGeneratedKeys();
            while (resultSet.next()) {
                generatedValues.add((Comparable)resultSet.getObject(1));
            }
        }
        String columnName = generatedKey.map(GeneratedKeyContext::getColumnName).orElse(null);
        return new GeneratedKeysResultSet(columnName, generatedValues.iterator(), this);
    }

    private Optional<GeneratedKeyContext> findGeneratedKey() {
        return this.executionContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)this.executionContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    protected DriverExecutor getExecutor() {
        return this.executor;
    }

    @Override
    @Generated
    protected StatementManager getStatementManager() {
        return this.statementManager;
    }
}

