/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverExecutor;
import org.apache.shardingsphere.driver.executor.batch.BatchExecutionUnit;
import org.apache.shardingsphere.driver.executor.batch.BatchPreparedStatementExecutor;
import org.apache.shardingsphere.driver.executor.callback.impl.PreparedStatementExecuteQueryCallback;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractPreparedStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.driver.jdbc.core.statement.metadata.ShardingSphereParameterMetaData;
import org.apache.shardingsphere.driver.jdbc.exception.SQLExceptionErrorCode;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.decider.engine.SQLFederationDeciderEngine;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.RawExecutionRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StorageConnectorReusableRule;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.util.exception.sql.SQLWrapperException;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.traffic.engine.TrafficEngine;
import org.apache.shardingsphere.traffic.exception.EmptyTrafficExecutionUnitException;
import org.apache.shardingsphere.traffic.rule.TrafficRule;

public final class ShardingSpherePreparedStatement
extends AbstractPreparedStatementAdapter {
    private final ShardingSphereConnection connection;
    private final MetaDataContexts metaDataContexts;
    private final String sql;
    private final List<PreparedStatement> statements;
    private final List<List<Object>> parameterSets;
    private final SQLStatement sqlStatement;
    private final SQLStatementContext<?> sqlStatementContext;
    private final StatementOption statementOption;
    private final ParameterMetaData parameterMetaData;
    private final DriverExecutor executor;
    private final BatchPreparedStatementExecutor batchPreparedStatementExecutor;
    private final Collection<Comparable<?>> generatedValues = new LinkedList();
    private final KernelProcessor kernelProcessor;
    private final boolean statementsCacheable;
    private final TrafficRule trafficRule;
    private final StatementManager statementManager;
    private final EventBusContext eventBusContext;
    private ExecutionContext executionContext;
    private ResultSet currentResultSet;
    private String trafficInstanceId;
    private SQLFederationDeciderContext deciderContext;

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, 1, false, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, 1, false, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this(connection, sql, 1003, 1007, 1, 1 == autoGeneratedKeys, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, String[] columns) throws SQLException {
        this(connection, sql, 1003, 1007, 1, true, columns);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, null);
    }

    private ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys, String[] columns) throws SQLException {
        if (Strings.isNullOrEmpty((String)sql)) {
            SQLExceptionErrorCode errorCode = SQLExceptionErrorCode.SQL_STRING_NULL_OR_EMPTY;
            throw new SQLException(errorCode.getErrorMessage(), errorCode.getSqlState(), errorCode.getErrorCode());
        }
        this.connection = connection;
        this.metaDataContexts = connection.getContextManager().getMetaDataContexts();
        this.eventBusContext = connection.getContextManager().getInstanceContext().getEventBusContext();
        this.sql = sql;
        this.statements = new ArrayList<PreparedStatement>();
        this.parameterSets = new ArrayList<List<Object>>();
        SQLParserRule sqlParserRule = (SQLParserRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        ShardingSphereSQLParserEngine sqlParserEngine = sqlParserRule.getSQLParserEngine(DatabaseTypeEngine.getTrunkDatabaseTypeName((DatabaseType)this.metaDataContexts.getMetaData().getDatabase(connection.getDatabaseName()).getResource().getDatabaseType()));
        this.sqlStatement = sqlParserEngine.parse(sql, true);
        this.sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.metaDataContexts.getMetaData().getDatabases(), (SQLStatement)this.sqlStatement, (String)connection.getDatabaseName());
        this.parameterMetaData = new ShardingSphereParameterMetaData(this.sqlStatement);
        this.statementOption = returnGeneratedKeys ? new StatementOption(true, columns) : new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.executor = new DriverExecutor(connection);
        JDBCExecutor jdbcExecutor = new JDBCExecutor(connection.getContextManager().getExecutorEngine(), connection.isHoldTransaction());
        this.batchPreparedStatementExecutor = new BatchPreparedStatementExecutor(this.metaDataContexts, jdbcExecutor, connection.getDatabaseName(), this.eventBusContext);
        this.kernelProcessor = new KernelProcessor();
        this.statementsCacheable = this.isStatementsCacheable(this.metaDataContexts.getMetaData().getDatabase(connection.getDatabaseName()).getRuleMetaData());
        this.trafficRule = (TrafficRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(TrafficRule.class);
        this.statementManager = new StatementManager();
    }

    private boolean isStatementsCacheable(ShardingSphereRuleMetaData databaseRuleMetaData) {
        return databaseRuleMetaData.findRules(StorageConnectorReusableRule.class).size() == databaseRuleMetaData.getRules().size() && !HintManager.isInstantiated();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingSphereResultSet result;
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                ResultSet resultSet = this.statements.iterator().next().executeQuery();
                return resultSet;
            }
            this.clearPrevious();
            QueryContext queryContext = this.createQueryContext();
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                ResultSet resultSet = (ResultSet)this.executor.getTrafficExecutor().execute(executionUnit, (statement, sql) -> ((PreparedStatement)statement).executeQuery());
                return resultSet;
            }
            this.deciderContext = ShardingSpherePreparedStatement.decide(queryContext, this.metaDataContexts.getMetaData().getProps(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()));
            if (this.deciderContext.isUseSQLFederation()) {
                ResultSet executionUnit = this.executeFederationQuery(queryContext);
                return executionUnit;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            List<QueryResult> queryResults = this.executeQuery0();
            MergedResult mergedResult = this.mergeQuery(queryResults);
            result = new ShardingSphereResultSet(this.getShardingSphereResultSet(), mergedResult, this, this.executionContext);
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    private static SQLFederationDeciderContext decide(QueryContext queryContext, ConfigurationProperties props, ShardingSphereDatabase database) {
        SQLFederationDeciderEngine deciderEngine = new SQLFederationDeciderEngine(database.getRuleMetaData().getRules(), props);
        return deciderEngine.decide(queryContext, database);
    }

    private JDBCExecutionUnit createTrafficExecutionUnit(String trafficInstanceId, QueryContext queryContext) throws SQLException {
        ExecutionUnit executionUnit;
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        ExecutionGroupContext context = prepareEngine.prepare(new RouteContext(), Collections.singletonList(executionUnit = new ExecutionUnit(trafficInstanceId, new SQLUnit(queryContext.getSql(), queryContext.getParameters()))));
        if (context.getInputGroups().isEmpty() || ((ExecutionGroup)context.getInputGroups().iterator().next()).getInputs().isEmpty()) {
            throw new EmptyTrafficExecutionUnitException();
        }
        return (JDBCExecutionUnit)((ExecutionGroup)context.getInputGroups().iterator().next()).getInputs().iterator().next();
    }

    private Optional<String> getInstanceIdAndSet(QueryContext queryContext) {
        Optional<String> result = this.connection.getConnectionContext().getTrafficInstanceId();
        if (!result.isPresent()) {
            result = this.getInstanceId(queryContext);
        }
        if (this.connection.isHoldTransaction() && result.isPresent()) {
            this.connection.getConnectionContext().setTrafficInstanceId(result.get());
        }
        return result;
    }

    private Optional<String> getInstanceId(QueryContext queryContext) {
        InstanceContext instanceContext = this.connection.getContextManager().getInstanceContext();
        return null != this.trafficRule && !this.trafficRule.getStrategyRules().isEmpty() ? new TrafficEngine(this.trafficRule, instanceContext).dispatch(queryContext, this.connection.isHoldTransaction()) : Optional.empty();
    }

    private void resetParameters() throws SQLException {
        this.parameterSets.clear();
        this.parameterSets.add(this.getParameters());
        this.replaySetParameter();
    }

    private List<ResultSet> getShardingSphereResultSet() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (PreparedStatement each : this.statements) {
            ResultSet resultSet = this.getResultSet(each);
            result.add(resultSet);
        }
        return result;
    }

    private List<QueryResult> executeQuery0() throws SQLException {
        if (this.hasRawExecutionRule()) {
            return this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext)).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        }
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext();
        this.cacheStatements(executionGroupContext.getInputGroups());
        return this.executor.getRegularExecutor().executeQuery(executionGroupContext, this.executionContext.getQueryContext(), new PreparedStatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), this.sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown(), this.eventBusContext));
    }

    private ResultSet executeFederationQuery(QueryContext queryContext) throws SQLException {
        PreparedStatementExecuteQueryCallback callback = new PreparedStatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), this.sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown(), this.eventBusContext);
        FederationContext context = new FederationContext(false, queryContext, this.metaDataContexts.getMetaData().getDatabases());
        return this.executor.getFederationExecutor().executeQuery(this.createDriverExecutionPrepareEngine(), (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine() {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", maxConnectionsSizePerQuery, (ExecutorConnectionManager)this.connection.getConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType());
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                int n = this.statements.iterator().next().executeUpdate();
                return n;
            }
            this.clearPrevious();
            QueryContext queryContext = this.createQueryContext();
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                int n = (Integer)this.executor.getTrafficExecutor().execute(executionUnit, (statement, sql) -> ((PreparedStatement)statement).executeUpdate());
                return n;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.hasRawExecutionRule()) {
                List executeResults = this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext));
                int n = this.accumulate(executeResults);
                return n;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executor.getRegularExecutor().executeUpdate(executionGroupContext, this.executionContext.getQueryContext(), this.executionContext.getRouteContext().getRouteUnits(), this.createExecuteUpdateCallback());
            return n;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.clearBatch();
        }
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    private JDBCExecutorCallback<Integer> createExecuteUpdateCallback() {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Integer>(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), this.sqlStatement, isExceptionThrown, this.eventBusContext){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return ((PreparedStatement)statement).executeUpdate();
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                boolean bl = this.statements.iterator().next().execute();
                return bl;
            }
            this.clearPrevious();
            QueryContext queryContext = this.createQueryContext();
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                boolean bl = (Boolean)this.executor.getTrafficExecutor().execute(executionUnit, (statement, sql) -> ((PreparedStatement)statement).execute());
                return bl;
            }
            this.deciderContext = ShardingSpherePreparedStatement.decide(queryContext, this.metaDataContexts.getMetaData().getProps(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()));
            if (this.deciderContext.isUseSQLFederation()) {
                ResultSet resultSet = this.executeFederationQuery(queryContext);
                boolean bl = null != resultSet;
                return bl;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (this.hasRawExecutionRule()) {
                List executeResults = this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(), this.executionContext.getQueryContext(), new RawSQLExecutorCallback(this.eventBusContext));
                boolean bl = executeResults.iterator().next() instanceof QueryResult;
                return bl;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            boolean bl = this.executor.getRegularExecutor().execute(executionGroupContext, this.executionContext.getQueryContext(), this.executionContext.getRouteContext().getRouteUnits(), this.createExecuteCallback());
            return bl;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.clearBatch();
        }
    }

    private boolean hasRawExecutionRule() {
        for (ShardingSphereRule each : this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules()) {
            if (!(each instanceof RawExecutionRule)) continue;
            return true;
        }
        return false;
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionGroupContext() throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules()).prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private ExecutionGroupContext<JDBCExecutionUnit> createExecutionGroupContext() throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        return prepareEngine.prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private JDBCExecutorCallback<Boolean> createExecuteCallback() {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Boolean>(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType(), this.sqlStatement, isExceptionThrown, this.eventBusContext){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return ((PreparedStatement)statement).execute();
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (null != this.trafficInstanceId) {
            return this.executor.getTrafficExecutor().getResultSet();
        }
        if (null != this.deciderContext && this.deciderContext.isUseSQLFederation()) {
            return this.executor.getFederationExecutor().getResultSet();
        }
        if (this.executionContext.getSqlStatementContext() instanceof SelectStatementContext || this.executionContext.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets();
            MergedResult mergedResult = this.mergeQuery(this.getQueryResults(resultSets));
            this.currentResultSet = new ShardingSphereResultSet(resultSets, mergedResult, this, this.executionContext);
        }
        return this.currentResultSet;
    }

    private ResultSet getResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    private List<ResultSet> getResultSets() throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (Statement statement : this.statements) {
            result.add(statement.getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) {
        SQLCheckEngine.check((SQLStatementContext)queryContext.getSqlStatementContext(), (List)queryContext.getParameters(), (Collection)this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules(), (String)this.connection.getDatabaseName(), (Map)this.metaDataContexts.getMetaData().getDatabases(), null);
        ExecutionContext result = this.kernelProcessor.generateExecutionContext(queryContext, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps(), this.connection.getConnectionContext());
        this.findGeneratedKey(result).ifPresent(generatedKey -> this.generatedValues.addAll(generatedKey.getGeneratedValues()));
        return result;
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext, String trafficInstanceId) {
        ExecutionUnit executionUnit = new ExecutionUnit(trafficInstanceId, new SQLUnit(queryContext.getSql(), queryContext.getParameters()));
        return new ExecutionContext(queryContext, Collections.singletonList(executionUnit), new RouteContext());
    }

    private QueryContext createQueryContext() {
        ArrayList<Object> parameters = new ArrayList<Object>(this.getParameters());
        if (this.sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)this.sqlStatementContext).setUpParameters(parameters);
        }
        return new QueryContext(this.sqlStatementContext, this.sql, parameters);
    }

    private MergedResult mergeQuery(List<QueryResult> queryResults) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()), this.metaDataContexts.getMetaData().getProps(), this.connection.getConnectionContext());
        return mergeEngine.merge(queryResults, this.executionContext.getSqlStatementContext());
    }

    private void cacheStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> executionGroups) throws SQLException {
        for (ExecutionGroup<JDBCExecutionUnit> each : executionGroups) {
            each.getInputs().forEach(eachInput -> {
                this.statements.add((PreparedStatement)eachInput.getStorageResource());
                this.parameterSets.add(eachInput.getExecutionUnit().getSqlUnit().getParameters());
            });
        }
        this.replay();
    }

    private void replay() throws SQLException {
        this.replaySetParameter();
        for (Statement statement : this.statements) {
            this.getMethodInvocationRecorder().replay(statement);
        }
    }

    private void replaySetParameter() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            this.replaySetParameter(this.statements.get(i), this.parameterSets.get(i));
        }
    }

    private void clearPrevious() {
        this.statements.clear();
        this.parameterSets.clear();
        this.generatedValues.clear();
    }

    private Optional<GeneratedKeyContext> findGeneratedKey(ExecutionContext executionContext) {
        return executionContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)executionContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey(this.executionContext);
        if (generatedKey.isPresent() && this.statementOption.isReturnGeneratedKeys() && !this.generatedValues.isEmpty()) {
            return new GeneratedKeysResultSet(generatedKey.get().getColumnName(), this.generatedValues.iterator(), this);
        }
        for (PreparedStatement statement : this.statements) {
            ResultSet resultSet = statement.getGeneratedKeys();
            while (resultSet.next()) {
                this.generatedValues.add((Comparable)resultSet.getObject(1));
            }
        }
        String columnName = generatedKey.map(GeneratedKeyContext::getColumnName).orElse(null);
        return new GeneratedKeysResultSet(columnName, this.generatedValues.iterator(), this);
    }

    @Override
    public void addBatch() {
        try {
            QueryContext queryContext = this.createQueryContext();
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            this.executionContext = null != this.trafficInstanceId ? this.createExecutionContext(queryContext, this.trafficInstanceId) : this.createExecutionContext(queryContext);
            this.batchPreparedStatementExecutor.addBatchForExecutionUnits(this.executionContext.getExecutionUnits());
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (null == this.executionContext) {
            return new int[0];
        }
        try {
            this.initBatchPreparedStatementExecutor();
            int[] nArray = this.batchPreparedStatementExecutor.executeBatch(this.executionContext.getSqlStatementContext());
            return nArray;
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw ex;
        }
        finally {
            this.clearBatch();
        }
    }

    private void initBatchPreparedStatementExecutor() throws SQLException {
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", ((Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), (ExecutorConnectionManager)this.connection.getConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getResource().getDatabaseType());
        ArrayList<ExecutionUnit> executionUnits = new ArrayList<ExecutionUnit>(this.batchPreparedStatementExecutor.getBatchExecutionUnits().size());
        for (BatchExecutionUnit each : this.batchPreparedStatementExecutor.getBatchExecutionUnits()) {
            ExecutionUnit executionUnit = each.getExecutionUnit();
            executionUnits.add(executionUnit);
        }
        this.batchPreparedStatementExecutor.init((ExecutionGroupContext<JDBCExecutionUnit>)prepareEngine.prepare(this.executionContext.getRouteContext(), executionUnits));
        this.setBatchParametersForStatements();
    }

    private void setBatchParametersForStatements() throws SQLException {
        for (Statement each : this.batchPreparedStatementExecutor.getStatements()) {
            List<List<Object>> parameterSet = this.batchPreparedStatementExecutor.getParameterSet(each);
            for (List<Object> eachParameters : parameterSet) {
                this.replaySetParameter((PreparedStatement)each, eachParameters);
                ((PreparedStatement)each).addBatch();
            }
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.currentResultSet = null;
        this.batchPreparedStatementExecutor.clear();
        this.clearParameters();
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        return this.metaDataContexts.getMetaData().getDatabase(this.connection.getDatabaseName()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).isNeedAccumulate(this.executionContext.getSqlStatementContext().getTablesContext().getTableNames()));
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    public ParameterMetaData getParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    @Generated
    protected DriverExecutor getExecutor() {
        return this.executor;
    }

    @Override
    @Generated
    protected StatementManager getStatementManager() {
        return this.statementManager;
    }
}

