/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.WrapperAdapter;
import org.apache.shardingsphere.driver.jdbc.exception.SQLExceptionErrorCode;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;

public final class ShardingSphereResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private final ShardingSphereDatabase database;
    private final SQLStatementContext<?> sqlStatementContext;

    @Override
    public int getColumnCount() throws SQLException {
        if (this.sqlStatementContext instanceof SelectStatementContext) {
            if (this.hasSelectExpandProjections()) {
                return ((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().size();
            }
            return this.resultSetMetaData.getColumnCount();
        }
        return this.resultSetMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.resultSetMetaData.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.resultSetMetaData.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.resultSetMetaData.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.resultSetMetaData.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.resultSetMetaData.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.resultSetMetaData.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.resultSetMetaData.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (this.hasSelectExpandProjections()) {
            this.checkColumnIndex(column);
            Projection projection = (Projection)((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().get(column - 1);
            if (projection instanceof AggregationDistinctProjection) {
                return DerivedColumn.isDerivedColumnName((String)projection.getColumnLabel()) ? projection.getExpression() : projection.getColumnLabel();
            }
        }
        return this.resultSetMetaData.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.hasSelectExpandProjections()) {
            this.checkColumnIndex(column);
            Projection projection = (Projection)((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().get(column - 1);
            if (projection instanceof ColumnProjection) {
                return ((ColumnProjection)projection).getName();
            }
            if (projection instanceof AggregationDistinctProjection) {
                return DerivedColumn.isDerivedColumnName((String)projection.getColumnLabel()) ? projection.getExpression() : projection.getColumnLabel();
            }
        }
        return this.resultSetMetaData.getColumnName(column);
    }

    private boolean hasSelectExpandProjections() {
        return this.sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections().isEmpty();
    }

    private void checkColumnIndex(int column) throws SQLException {
        List actualProjections = ((SelectStatementContext)this.sqlStatementContext).getProjectionsContext().getExpandProjections();
        if (column > actualProjections.size()) {
            SQLExceptionErrorCode errorCode = SQLExceptionErrorCode.COLUMN_INDEX_OUT_OF_RANGE;
            throw new SQLException(errorCode.getErrorMessage(), errorCode.getSqlState(), errorCode.getErrorCode());
        }
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.resultSetMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.resultSetMetaData.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String actualTableName = this.resultSetMetaData.getTableName(column);
        Optional<ShardingSphereRule> rule = this.database.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataNodeContainedRule).findFirst();
        return rule.isPresent() ? ((DataNodeContainedRule)rule.get()).findLogicTableByActualTable(actualTableName).orElse(actualTableName) : actualTableName;
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.resultSetMetaData.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.resultSetMetaData.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.resultSetMetaData.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.resultSetMetaData.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnClassName(column);
    }

    @Generated
    public ShardingSphereResultSetMetaData(ResultSetMetaData resultSetMetaData, ShardingSphereDatabase database, SQLStatementContext<?> sqlStatementContext) {
        this.resultSetMetaData = resultSetMetaData;
        this.database = database;
        this.sqlStatementContext = sqlStatementContext;
    }
}

