/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.loader;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;

public final class SchemaLoader {
    public static ShardingSphereSchema load(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules, Properties props) throws SQLException {
        DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType(dataSourceMap.values());
        Map<String, TableMetaData> tableMetaDataMap = TableMetaDataBuilder.load(SchemaLoader.getAllTableNames(rules), new SchemaBuilderMaterials(databaseType, dataSourceMap, rules, new ConfigurationProperties(null == props ? new Properties() : props)));
        return new ShardingSphereSchema(tableMetaDataMap);
    }

    private static Collection<String> getAllTableNames(Collection<ShardingSphereRule> rules) {
        return rules.stream().filter(rule -> rule instanceof TableContainedRule).flatMap(shardingSphereRule -> ((TableContainedRule)shardingSphereRule).getTables().stream()).collect(Collectors.toSet());
    }
}

