/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;

public final class DropDatabaseDiscoveryRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropDatabaseDiscoveryRuleStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "Database discovery";

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, sqlStatement, currentRuleConfig);
        this.checkIsInUse(schemaName, sqlStatement, shardingSphereMetaData);
    }

    private void checkCurrentRuleConfiguration(String schemaName, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException(RULE_TYPE, schemaName));
        this.checkIsExist(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkIsExist(String schemaName, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getRuleNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedRuleNames.isEmpty(), () -> new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkIsInUse(String schemaName, DropDatabaseDiscoveryRuleStatement sqlStatement, ShardingSphereMetaData shardingSphereMetaData) throws DistSQLException {
        Collection rulesInUse = shardingSphereMetaData.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Collections.singletonList("auto_aware_data_source_name"))).map(each -> each.export("auto_aware_data_source_name")).filter(Optional::isPresent).map(each -> (Collection)each.get()).flatMap(Collection::stream).collect(Collectors.toSet());
        Collection invalid = sqlStatement.getRuleNames().stream().filter(rulesInUse::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), () -> new RuleInUsedException(RULE_TYPE, schemaName, invalid));
    }

    public boolean updateCurrentRuleConfiguration(DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getRuleNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return false;
    }

    private void dropRule(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<DatabaseDiscoveryDataSourceRuleConfiguration> dataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(dataSource -> dataSource.getGroupName().equals(ruleName)).findAny();
        dataSourceRuleConfig.ifPresent(op -> currentRuleConfig.getDataSources().remove(dataSourceRuleConfig.get()));
    }

    public boolean hasAnyOneToBeDropped(DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        return this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && !this.getIdenticalData(currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName).collect(Collectors.toSet()), sqlStatement.getRuleNames()).isEmpty();
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return DropDatabaseDiscoveryRuleStatement.class.getName();
    }
}

