/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.environment;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingEnvironmentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingEnvironmentManager.class);
    private final PipelineDataSourceFactory dataSourceFactory = new PipelineDataSourceFactory();

    public void cleanupTargetTables(JobConfiguration jobConfig) throws SQLException {
        List tables = jobConfig.getHandleConfig().splitLogicTableNames();
        log.info("cleanupTargetTables, tables={}", (Object)tables);
        YamlPipelineDataSourceConfiguration target = jobConfig.getPipelineConfig().getTarget();
        try (PipelineDataSourceWrapper dataSource = this.dataSourceFactory.newInstance(PipelineDataSourceConfigurationFactory.newInstance((String)target.getType(), (String)target.getParameter()));
             Connection connection = dataSource.getConnection();){
            for (String each : tables) {
                String sql = PipelineSQLBuilderFactory.getSQLBuilder(jobConfig.getHandleConfig().getTargetDatabaseType()).buildTruncateSQL(each);
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    preparedStatement.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
        }
    }
}

