/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered.spi;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.detect.RuleAlteredJobAlmostCompletedParameter;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.spi.detect.JobCompletionDetectAlgorithm;

public final class IdleRuleAlteredJobCompletionDetectAlgorithm
implements JobCompletionDetectAlgorithm<RuleAlteredJobAlmostCompletedParameter> {
    public static final String IDLE_MINUTE_THRESHOLD_KEY = "incremental-task-idle-minute-threshold";
    public static final String IDLE_SECOND_THRESHOLD_KEY = "incremental-task-idle-second-threshold";
    public static final long DEFAULT_IDLE_SECOND_THRESHOLD = TimeUnit.MINUTES.toSeconds(30L);
    private Properties props = new Properties();
    private long incrementalTaskIdleSecondThreshold = DEFAULT_IDLE_SECOND_THRESHOLD;

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void init() {
        Preconditions.checkArgument((this.props.containsKey(IDLE_MINUTE_THRESHOLD_KEY) || this.props.containsKey(IDLE_SECOND_THRESHOLD_KEY) ? 1 : 0) != 0, (Object)"incremental task idle threshold can not be null.");
        this.incrementalTaskIdleSecondThreshold = this.props.containsKey(IDLE_SECOND_THRESHOLD_KEY) ? Long.parseLong(this.props.getProperty(IDLE_SECOND_THRESHOLD_KEY)) : TimeUnit.MINUTES.toSeconds(Long.parseLong(this.props.getProperty(IDLE_MINUTE_THRESHOLD_KEY)));
        Preconditions.checkArgument((this.incrementalTaskIdleSecondThreshold > 0L ? 1 : 0) != 0, (Object)"incremental task idle threshold must be positive.");
    }

    public String getType() {
        return "IDLE";
    }

    public boolean isAlmostCompleted(RuleAlteredJobAlmostCompletedParameter parameter) {
        Collection jobProgresses;
        int jobShardingCount = parameter.getJobShardingCount();
        if (!IdleRuleAlteredJobCompletionDetectAlgorithm.isAllProgressesFilled(jobShardingCount, jobProgresses = parameter.getJobProgresses())) {
            return false;
        }
        if (!IdleRuleAlteredJobCompletionDetectAlgorithm.isAllInventoryTasksCompleted(jobProgresses)) {
            return false;
        }
        Collection<Long> incrementalTasksIdleSeconds = IdleRuleAlteredJobCompletionDetectAlgorithm.getIncrementalTasksIdleSeconds(jobProgresses);
        return incrementalTasksIdleSeconds.stream().allMatch(each -> each >= this.incrementalTaskIdleSecondThreshold);
    }

    private static boolean isAllProgressesFilled(int jobShardingCount, Collection<JobProgress> jobProgresses) {
        return jobShardingCount == jobProgresses.size() && jobProgresses.stream().allMatch(Objects::nonNull);
    }

    private static boolean isAllInventoryTasksCompleted(Collection<JobProgress> jobProgresses) {
        return jobProgresses.stream().flatMap(each -> each.getInventoryTaskProgressMap().values().stream()).allMatch(each -> each.getPosition() instanceof FinishedPosition);
    }

    private static Collection<Long> getIncrementalTasksIdleSeconds(Collection<JobProgress> jobProgresses) {
        long currentTimeMillis = System.currentTimeMillis();
        return jobProgresses.stream().flatMap(each -> each.getIncrementalTaskProgressMap().values().stream()).map(each -> {
            long latestActiveTimeMillis = each.getIncrementalTaskDelay().getLatestActiveTimeMillis();
            return latestActiveTimeMillis > 0L ? TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis - latestActiveTimeMillis) : 0L;
        }).collect(Collectors.toList());
    }

    public String toString() {
        return "IdleRuleAlteredJobCompletionDetectAlgorithm{props=" + this.props + '}';
    }

    @Generated
    public long getIncrementalTaskIdleSecondThreshold() {
        return this.incrementalTaskIdleSecondThreshold;
    }
}

