/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered.prepare;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCreationException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelFactory;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rulealtered.YamlOnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rulealtered.OnRuleAlteredActionConfigurationYamlSwapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTaskSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTaskSplitter.class);

    public List<InventoryTask> splitInventoryData(RuleAlteredJobContext jobContext) {
        LinkedList<InventoryTask> result = new LinkedList<InventoryTask>();
        TaskConfiguration taskConfig = jobContext.getTaskConfig();
        PipelineChannelFactory pipelineChannelFactory = jobContext.getRuleAlteredContext().getPipelineChannelFactory();
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        PipelineDataSourceWrapper dataSource = jobContext.getSourceDataSource();
        PipelineTableMetaDataLoader metaDataLoader = jobContext.getSourceMetaDataLoader();
        ExecuteEngine importerExecuteEngine = jobContext.getRuleAlteredContext().getImporterExecuteEngine();
        for (InventoryDumperConfiguration each : this.splitDumperConfig(jobContext, taskConfig.getDumperConfig())) {
            result.add(new InventoryTask(each, taskConfig.getImporterConfig(), pipelineChannelFactory, dataSourceManager, (DataSource)dataSource, metaDataLoader, importerExecuteEngine));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitDumperConfig(RuleAlteredJobContext jobContext, DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        PipelineDataSourceWrapper dataSource = jobContext.getSourceDataSource();
        PipelineTableMetaDataLoader metaDataLoader = jobContext.getSourceMetaDataLoader();
        for (InventoryDumperConfiguration each : this.splitByTable(dumperConfig)) {
            result.addAll(this.splitByPrimaryKey(jobContext, (DataSource)dataSource, metaDataLoader, each));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByTable(DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        dumperConfig.getTableNameMap().forEach((key, value) -> {
            InventoryDumperConfiguration inventoryDumperConfig = new InventoryDumperConfiguration(dumperConfig);
            inventoryDumperConfig.setTableName(key);
            inventoryDumperConfig.setPosition((IngestPosition)new PlaceholderPosition());
            result.add(inventoryDumperConfig);
        });
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByPrimaryKey(RuleAlteredJobContext jobContext, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader, InventoryDumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        RuleAlteredContext ruleAlteredContext = jobContext.getRuleAlteredContext();
        OnRuleAlteredActionConfiguration.InputConfiguration inputConfig = ruleAlteredContext.getOnRuleAlteredActionConfig().getInput();
        if (null == inputConfig) {
            inputConfig = new OnRuleAlteredActionConfigurationYamlSwapper.InputConfigurationSwapper().swapToObject(YamlOnRuleAlteredActionConfiguration.YamlInputConfiguration.buildWithDefaultValue());
        }
        int batchSize = inputConfig.getBatchSize();
        JobRateLimitAlgorithm rateLimitAlgorithm = ruleAlteredContext.getInputRateLimitAlgorithm();
        Collection<IngestPosition<?>> inventoryPositions = this.getInventoryPositions(jobContext, dumperConfig, dataSource, metaDataLoader);
        int i = 0;
        for (IngestPosition<?> inventoryPosition : inventoryPositions) {
            InventoryDumperConfiguration splitDumperConfig = new InventoryDumperConfiguration((DumperConfiguration)dumperConfig);
            splitDumperConfig.setPosition(inventoryPosition);
            splitDumperConfig.setShardingItem(Integer.valueOf(i++));
            splitDumperConfig.setTableName(dumperConfig.getTableName());
            splitDumperConfig.setPrimaryKey(dumperConfig.getPrimaryKey());
            splitDumperConfig.setBatchSize(batchSize);
            splitDumperConfig.setRateLimitAlgorithm(rateLimitAlgorithm);
            result.add(splitDumperConfig);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getInventoryPositions(RuleAlteredJobContext jobContext, InventoryDumperConfiguration dumperConfig, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader) {
        JobProgress initProgress = jobContext.getInitProgress();
        if (null != initProgress && initProgress.getStatus() != JobStatus.PREPARING_FAILURE) {
            Collection<IngestPosition<?>> result = initProgress.getInventoryPosition(dumperConfig.getTableName()).values();
            for (IngestPosition ingestPosition : result) {
                if (!(ingestPosition instanceof PrimaryKeyPosition)) continue;
                String primaryKey = metaDataLoader.getTableMetaData(dumperConfig.getTableName()).getPrimaryKeyColumns().get(0);
                dumperConfig.setPrimaryKey(primaryKey);
                break;
            }
            return result;
        }
        PipelineTableMetaData tableMetaData = metaDataLoader.getTableMetaData(dumperConfig.getTableName());
        if (this.isSpiltByPrimaryKeyRange(tableMetaData, dumperConfig.getTableName())) {
            String primaryKey = tableMetaData.getPrimaryKeyColumns().get(0);
            dumperConfig.setPrimaryKey(primaryKey);
            return this.getPositionByPrimaryKeyRange(jobContext, dataSource, dumperConfig);
        }
        throw new PipelineJobCreationException("Can not split by primary key range for table " + dumperConfig.getTableName());
    }

    private boolean isSpiltByPrimaryKeyRange(PipelineTableMetaData tableMetaData, String tableName) {
        if (null == tableMetaData) {
            log.warn("Can't split range for table {}, reason: can not get table metadata ", (Object)tableName);
            return false;
        }
        List<String> primaryKeys = tableMetaData.getPrimaryKeyColumns();
        if (null == primaryKeys || primaryKeys.isEmpty()) {
            log.warn("Can't split range for table {}, reason: no primary key", (Object)tableName);
            return false;
        }
        if (primaryKeys.size() > 1) {
            log.warn("Can't split range for table {}, reason: primary key is union primary", (Object)tableName);
            return false;
        }
        if (this.isNotIntegerPrimary(tableMetaData.getColumnMetaData(primaryKeys.get(0)).getDataType())) {
            log.warn("Can't split range for table {}, reason: primary key is not integer number", (Object)tableName);
            return false;
        }
        return true;
    }

    private boolean isNotIntegerPrimary(int columnType) {
        return 4 != columnType && -5 != columnType && 5 != columnType && -6 != columnType;
    }

    private Collection<IngestPosition<?>> getPositionByPrimaryKeyRange(RuleAlteredJobContext jobContext, DataSource dataSource, InventoryDumperConfiguration dumperConfig) {
        ArrayList result = new ArrayList();
        JobConfiguration jobConfig = jobContext.getJobConfig();
        String sql = PipelineSQLBuilderFactory.getSQLBuilder(jobConfig.getHandleConfig().getSourceDatabaseType()).buildSplitByPrimaryKeyRangeSQL(dumperConfig.getTableName(), dumperConfig.getPrimaryKey());
        try (Connection connection = dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            long beginId = 0L;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                ps.setLong(1, beginId);
                ps.setLong(2, jobConfig.getHandleConfig().getShardingSize());
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        log.info("getPositionByPrimaryKeyRange, rs.next false, break");
                        break;
                    }
                    long endId = rs.getLong(1);
                    if (endId == 0L) {
                        log.info("getPositionByPrimaryKeyRange, endId is 0, break, tableName={}, primaryKey={}, beginId={}", new Object[]{dumperConfig.getTableName(), dumperConfig.getPrimaryKey(), beginId});
                        break;
                    }
                    result.add((IngestPosition<?>)new PrimaryKeyPosition(beginId, endId));
                    beginId = endId + 1L;
                    continue;
                }
            }
            if (0 == result.size()) {
                result.add((IngestPosition<?>)new PrimaryKeyPosition(0L, 0L));
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException(String.format("Split task for table %s by primary key %s error", dumperConfig.getTableName(), dumperConfig.getPrimaryKey()), ex);
        }
        return result;
    }
}

