/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobProgressDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobProgressDetector.class);

    public static boolean allInventoryTasksFinished(Collection<InventoryTask> inventoryTasks) {
        if (inventoryTasks.isEmpty()) {
            log.warn("inventoryTasks is empty");
        }
        return inventoryTasks.stream().allMatch(each -> each.getProgress().getPosition() instanceof FinishedPosition);
    }

    public static boolean isJobCompleted(int jobShardingCount, Collection<JobProgress> jobProgresses) {
        return jobShardingCount == jobProgresses.size() && jobProgresses.stream().allMatch(each -> null != each && !each.getStatus().isRunning());
    }

    @Generated
    private RuleAlteredJobProgressDetector() {
    }
}

