/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.PipelineConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.prepare.datasource.ActualTableDefinition;
import org.apache.shardingsphere.data.pipeline.api.prepare.datasource.TableDefinitionSQLType;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourcePreparer
implements DataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourcePreparer.class);
    private static final Pattern PATTERN_CREATE_TABLE_IF_NOT_EXISTS = Pattern.compile("CREATE\\s+TABLE\\s+IF\\s+NOT\\s+EXISTS\\s+", 2);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+", 2);
    private static final Pattern PATTERN_ALTER_TABLE = Pattern.compile("ALTER\\s+TABLE\\s+", 2);
    private static final String[] IGNORE_EXCEPTION_MESSAGE = new String[]{"multiple primary keys for table", "already exists"};

    protected final PipelineDataSourceWrapper getSourceCachedDataSource(PipelineConfiguration pipelineConfig, PipelineDataSourceManager dataSourceManager) {
        return dataSourceManager.getDataSource(PipelineDataSourceConfigurationFactory.newInstance((String)pipelineConfig.getSource().getType(), (String)pipelineConfig.getSource().getParameter()));
    }

    protected final PipelineDataSourceWrapper getTargetCachedDataSource(PipelineConfiguration pipelineConfig, PipelineDataSourceManager dataSourceManager) {
        return dataSourceManager.getDataSource(PipelineDataSourceConfigurationFactory.newInstance((String)pipelineConfig.getTarget().getType(), (String)pipelineConfig.getTarget().getParameter()));
    }

    protected final void executeTargetTableSQL(Connection targetConnection, String sql) throws SQLException {
        log.info("execute target table sql: {}", (Object)sql);
        try (Statement statement = targetConnection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            for (String ignoreMessage : IGNORE_EXCEPTION_MESSAGE) {
                if (!ex.getMessage().contains(ignoreMessage)) continue;
                return;
            }
            throw ex;
        }
    }

    protected final Collection<String> splitTableDefinitionToSQLs(ActualTableDefinition actualTableDefinition) {
        return Arrays.stream(actualTableDefinition.getTableDefinition().split(";")).collect(Collectors.toList());
    }

    protected final TableDefinitionSQLType getTableDefinitionSQLType(String sql) {
        if (PATTERN_CREATE_TABLE.matcher(sql).find()) {
            return TableDefinitionSQLType.CREATE_TABLE;
        }
        if (PATTERN_ALTER_TABLE.matcher(sql).find()) {
            return TableDefinitionSQLType.ALTER_TABLE;
        }
        return TableDefinitionSQLType.UNKNOWN;
    }

    protected final String addIfNotExistsForCreateTableSQL(String createTableSQL) {
        if (PATTERN_CREATE_TABLE_IF_NOT_EXISTS.matcher(createTableSQL).find()) {
            return createTableSQL;
        }
        return PATTERN_CREATE_TABLE.matcher(createTableSQL).replaceFirst("CREATE TABLE IF NOT EXISTS ");
    }

    protected String replaceActualTableNameToLogicTableName(String createOrAlterTableSQL, String actualTableName, String logicTableName) {
        int start = createOrAlterTableSQL.indexOf(actualTableName);
        if (start <= 0) {
            return createOrAlterTableSQL;
        }
        int end = start + actualTableName.length();
        return new StringBuilder(createOrAlterTableSQL).replace(start, end, logicTableName).toString();
    }
}

