/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineTableMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineTableMetaDataLoader.class);
    private final PipelineDataSourceWrapper dataSource;
    private final Map<String, PipelineTableMetaData> tableMetaDataMap = new ConcurrentHashMap<String, PipelineTableMetaData>();

    public void loadTableMetaData(String tableNamePattern) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            long startMillis = System.currentTimeMillis();
            Map<String, PipelineTableMetaData> tableMetaDataMap = this.loadTableMetaData0(connection, tableNamePattern);
            log.info("loadTableMetaData, tableNamePattern={}, result={}, cost time={} ms", new Object[]{tableNamePattern, tableMetaDataMap, System.currentTimeMillis() - startMillis});
            this.tableMetaDataMap.putAll(tableMetaDataMap);
        }
    }

    private Map<String, PipelineTableMetaData> loadTableMetaData0(Connection connection, String tableNamePattern) throws SQLException {
        LinkedHashMap<String, Map> tablePipelineColumnMetaDataMap = new LinkedHashMap<String, Map>();
        ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), null, tableNamePattern, "%");
        Object object = null;
        try {
            while (resultSet.next()) {
                Set<String> primaryKeys;
                String columnName;
                int n = resultSet.getInt("ORDINAL_POSITION");
                String tableName = resultSet.getString("TABLE_NAME");
                Map columnMetaDataMap = tablePipelineColumnMetaDataMap.computeIfAbsent(tableName, k -> new LinkedHashMap());
                if (columnMetaDataMap.containsKey(columnName = resultSet.getString("COLUMN_NAME"))) continue;
                int dataType = resultSet.getInt("DATA_TYPE");
                String dataTypeName = resultSet.getString("TYPE_NAME");
                try {
                    primaryKeys = this.loadPrimaryKeys(connection, tableName);
                }
                catch (SQLException ex) {
                    log.error("loadPrimaryKeys failed, tableName={}", (Object)tableName);
                    throw ex;
                }
                boolean primaryKey = primaryKeys.contains(columnName);
                PipelineColumnMetaData columnMetaData = new PipelineColumnMetaData(n, columnName, dataType, dataTypeName, primaryKey);
                columnMetaDataMap.put(columnName, columnMetaData);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (object != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        LinkedHashMap<String, PipelineTableMetaData> result = new LinkedHashMap<String, PipelineTableMetaData>();
        for (Map.Entry entry : tablePipelineColumnMetaDataMap.entrySet()) {
            result.put((String)entry.getKey(), new PipelineTableMetaData((String)entry.getKey(), (Map)entry.getValue()));
        }
        return result;
    }

    private Set<String> loadPrimaryKeys(Connection connection, String tableName) throws SQLException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), connection.getSchema(), tableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    public PipelineTableMetaData getTableMetaData(String tableName) {
        PipelineTableMetaData result = this.tableMetaDataMap.get(tableName);
        if (null != result) {
            return result;
        }
        try {
            this.loadTableMetaData(tableName);
        }
        catch (SQLException ex) {
            throw new RuntimeException(String.format("Load metadata for table '%s' failed", tableName), ex);
        }
        result = this.tableMetaDataMap.get(tableName);
        if (null == result) {
            log.warn("getTableMetaData, can not load metadata for table '{}'", (Object)tableName);
        }
        return result;
    }

    @Generated
    public PipelineTableMetaDataLoader(PipelineDataSourceWrapper dataSource) {
        this.dataSource = dataSource;
    }
}

