/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.lock;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockRegistryService;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineSimpleLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineSimpleLock.class);
    private static volatile PipelineSimpleLock instance;
    private final LockRegistryService lockRegistryService;
    private final Map<String, Boolean> lockNameLockedMap;

    private PipelineSimpleLock() {
        Optional persistServiceOptional = PipelineContext.getContextManager().getMetaDataContexts().getMetaDataPersistService();
        persistServiceOptional.orElseThrow(() -> new RuntimeException("Could not get metadata persist service"));
        ClusterPersistRepository repository = (ClusterPersistRepository)((MetaDataPersistService)persistServiceOptional.get()).getRepository();
        this.lockRegistryService = new LockRegistryService(repository);
        this.lockNameLockedMap = Maps.newConcurrentMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PipelineSimpleLock getInstance() {
        if (null != instance) return instance;
        Class<PipelineSimpleLock> clazz = PipelineSimpleLock.class;
        synchronized (PipelineSimpleLock.class) {
            if (null != instance) return instance;
            instance = new PipelineSimpleLock();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean tryLock(String lockName, long timeoutMills) {
        log.info("tryLock, lockName={}, timeoutMills={}", (Object)lockName, (Object)timeoutMills);
        boolean result = this.lockRegistryService.tryLock(this.decorateLockName(lockName), timeoutMills);
        if (result) {
            this.lockNameLockedMap.put(lockName, true);
        }
        return result;
    }

    public void releaseLock(String lockName) {
        log.info("releaseLock, lockName={}", (Object)lockName);
        if (this.lockNameLockedMap.getOrDefault(lockName, false).booleanValue()) {
            this.lockNameLockedMap.remove(lockName);
            this.lockRegistryService.releaseLock(this.decorateLockName(lockName));
        }
    }

    private String decorateLockName(String lockName) {
        return "scaling-" + lockName;
    }
}

