/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.executor.LifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;

public final class ExecuteEngine {
    public static final String THREAD_NAME_FORMAT = "Scaling-execute-%d";
    private final ListeningExecutorService executorService;

    public static ExecuteEngine newCachedThreadInstance() {
        return new ExecuteEngine(MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(ExecutorThreadFactoryBuilder.build((String)THREAD_NAME_FORMAT))));
    }

    public static ExecuteEngine newFixedThreadInstance(int threadNumber) {
        return new ExecuteEngine(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(threadNumber, ExecutorThreadFactoryBuilder.build((String)THREAD_NAME_FORMAT))));
    }

    public Future<?> submit(LifecycleExecutor lifecycleExecutor) {
        return this.executorService.submit((Runnable)lifecycleExecutor);
    }

    public Future<?> submit(LifecycleExecutor lifecycleExecutor, ExecuteCallback executeCallback) {
        ListenableFuture result = this.executorService.submit((Runnable)lifecycleExecutor);
        Futures.addCallback((ListenableFuture)result, new ExecuteFutureCallback(executeCallback), (Executor)this.executorService);
        return result;
    }

    public Future<?> submitAll(Collection<? extends LifecycleExecutor> lifecycleExecutors, ExecuteCallback executeCallback) {
        ArrayList<ListenableFuture> listenableFutures = new ArrayList<ListenableFuture>(lifecycleExecutors.size());
        for (LifecycleExecutor lifecycleExecutor : lifecycleExecutors) {
            ListenableFuture listenableFuture = this.executorService.submit((Runnable)lifecycleExecutor);
            listenableFutures.add(listenableFuture);
        }
        ListenableFuture result = Futures.allAsList(listenableFutures);
        Futures.addCallback((ListenableFuture)result, new ExecuteFutureCallback(executeCallback), (Executor)this.executorService);
        return result;
    }

    @Generated
    private ExecuteEngine(ListeningExecutorService executorService) {
        this.executorService = executorService;
    }

    private static class ExecuteFutureCallback<V>
    implements FutureCallback<V> {
        private final ExecuteCallback executeCallback;

        public void onSuccess(V result) {
            this.executeCallback.onSuccess();
        }

        @ParametersAreNonnullByDefault
        public void onFailure(Throwable throwable) {
            this.executeCallback.onFailure(throwable);
        }

        @Generated
        public ExecuteFutureCallback(ExecuteCallback executeCallback) {
            this.executeCallback = executeCallback;
        }
    }
}

