/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.SingleTableDataCalculator;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.exception.ServiceLoaderInstantiationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleTableDataCalculatorRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleTableDataCalculatorRegistry.class);
    private static final Map<String, Map<String, SingleTableDataCalculator>> ALGORITHM_DATABASE_CALCULATOR_MAP = new HashMap<String, Map<String, SingleTableDataCalculator>>();

    public static SingleTableDataCalculator newServiceInstance(String algorithmType, String databaseType) {
        Map<String, SingleTableDataCalculator> calculatorMap = ALGORITHM_DATABASE_CALCULATOR_MAP.get(algorithmType);
        Preconditions.checkNotNull(calculatorMap, (Object)String.format("calculator not found for algorithmType '%s'", algorithmType));
        SingleTableDataCalculator calculator = calculatorMap.get(databaseType);
        Preconditions.checkNotNull((Object)calculator, (Object)String.format("calculator not found for algorithmType '%s' databaseType '%s'", algorithmType, databaseType));
        try {
            return (SingleTableDataCalculator)calculator.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ServiceLoaderInstantiationException(calculator.getClass(), (Exception)ex);
        }
    }

    static {
        ShardingSphereServiceLoader.register(SingleTableDataCalculator.class);
        for (SingleTableDataCalculator each : ShardingSphereServiceLoader.getSingletonServiceInstances(SingleTableDataCalculator.class)) {
            Map dataCalculatorMap = ALGORITHM_DATABASE_CALCULATOR_MAP.computeIfAbsent(each.getAlgorithmType(), algorithmType -> new HashMap());
            for (String databaseType : each.getDatabaseTypes()) {
                SingleTableDataCalculator replaced = dataCalculatorMap.put(databaseType, each);
                if (null == replaced) continue;
                log.warn("element replaced, algorithmType={}, databaseTypes={}, current={}, replaced={}", new Object[]{each.getAlgorithmType(), each.getDatabaseTypes(), each.getClass().getName(), replaced.getClass().getName()});
            }
        }
    }
}

