/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.impl.GovernanceRepositoryAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.registry.CoordinatorRegistryCenterInitializer;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobAPIFactory;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobConfigurationAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobOperateAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobStatisticsAPI;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;

public final class PipelineAPIFactory {
    private static final LazyInitializer<GovernanceRepositoryAPI> REPOSITORY_API_LAZY_INITIALIZER = new LazyInitializer<GovernanceRepositoryAPI>(){

        protected GovernanceRepositoryAPI initialize() {
            Optional persistServiceOptional = PipelineContext.getContextManager().getMetaDataContexts().getMetaDataPersistService();
            if (!persistServiceOptional.isPresent()) {
                throw new RuntimeException("persistService is not present");
            }
            ClusterPersistRepository repository = (ClusterPersistRepository)((MetaDataPersistService)persistServiceOptional.get()).getRepository();
            return new GovernanceRepositoryAPIImpl(repository);
        }
    };

    public static GovernanceRepositoryAPI getGovernanceRepositoryAPI() {
        return (GovernanceRepositoryAPI)REPOSITORY_API_LAZY_INITIALIZER.get();
    }

    public static JobStatisticsAPI getJobStatisticsAPI() {
        return ElasticJobAPIHolder.getInstance().getJobStatisticsAPI();
    }

    public static JobConfigurationAPI getJobConfigurationAPI() {
        return ElasticJobAPIHolder.getInstance().getJobConfigurationAPI();
    }

    public static JobOperateAPI getJobOperateAPI() {
        return ElasticJobAPIHolder.getInstance().getJobOperateAPI();
    }

    public static CoordinatorRegistryCenter getRegistryCenter() {
        return RegistryCenterHolder.getInstance();
    }

    @Generated
    private PipelineAPIFactory() {
    }

    private static final class RegistryCenterHolder {
        private static volatile CoordinatorRegistryCenter instance;

        private RegistryCenterHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static CoordinatorRegistryCenter getInstance() {
            if (null != instance) return instance;
            Class<PipelineAPIFactory> clazz = PipelineAPIFactory.class;
            synchronized (PipelineAPIFactory.class) {
                if (null != instance) return instance;
                instance = RegistryCenterHolder.createRegistryCenter();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static CoordinatorRegistryCenter createRegistryCenter() {
            CoordinatorRegistryCenterInitializer registryCenterInitializer = new CoordinatorRegistryCenterInitializer();
            ModeConfiguration modeConfig = PipelineContext.getModeConfig();
            return registryCenterInitializer.createRegistryCenter(modeConfig, "/scaling");
        }
    }

    private static final class ElasticJobAPIHolder {
        private static volatile ElasticJobAPIHolder instance;
        private final JobStatisticsAPI jobStatisticsAPI;
        private final JobConfigurationAPI jobConfigurationAPI;
        private final JobOperateAPI jobOperateAPI;

        private ElasticJobAPIHolder() {
            ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)PipelineContext.getModeConfig().getRepository();
            String namespace = repositoryConfig.getNamespace() + "/scaling";
            this.jobStatisticsAPI = JobAPIFactory.createJobStatisticsAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
            this.jobConfigurationAPI = JobAPIFactory.createJobConfigurationAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
            this.jobOperateAPI = JobAPIFactory.createJobOperateAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ElasticJobAPIHolder getInstance() {
            if (null != instance) return instance;
            Class<PipelineAPIFactory> clazz = PipelineAPIFactory.class;
            synchronized (PipelineAPIFactory.class) {
                if (null != instance) return instance;
                instance = new ElasticJobAPIHolder();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Generated
        public JobStatisticsAPI getJobStatisticsAPI() {
            return this.jobStatisticsAPI;
        }

        @Generated
        public JobConfigurationAPI getJobConfigurationAPI() {
            return this.jobConfigurationAPI;
        }

        @Generated
        public JobOperateAPI getJobOperateAPI() {
            return this.jobOperateAPI;
        }
    }
}

