/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.handler.CuratorZookeeperExceptionHandler;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener.SessionConnectionListener;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperProperties;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperPropertyKey;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class CuratorZookeeperRepository
implements ClusterPersistRepository {
    private final Map<String, CuratorCache> caches = new HashMap<String, CuratorCache>();
    private CuratorFramework client;
    private final CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
    private final Map<String, InterProcessLock> locks = new ConcurrentHashMap<String, InterProcessLock>();
    private Properties props = new Properties();

    public void init(ClusterPersistRepositoryConfiguration config) {
        ZookeeperProperties zookeeperProps = new ZookeeperProperties(this.props);
        this.client = this.buildCuratorClient(config, zookeeperProps);
        this.initCuratorClient(zookeeperProps);
    }

    private CuratorFramework buildCuratorClient(ClusterPersistRepositoryConfiguration config, ZookeeperProperties zookeeperProps) {
        String digest;
        int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
        int maxRetries = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.MAX_RETRIES);
        int timeToLiveSeconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.TIME_TO_LIVE_SECONDS);
        int operationTimeoutMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.OPERATION_TIMEOUT_MILLISECONDS);
        this.builder.connectString(config.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryIntervalMilliseconds, maxRetries, retryIntervalMilliseconds * maxRetries)).namespace(config.getNamespace());
        if (0 != timeToLiveSeconds) {
            this.builder.sessionTimeoutMs(timeToLiveSeconds * 1000);
        }
        if (0 != operationTimeoutMilliseconds) {
            this.builder.connectionTimeoutMs(operationTimeoutMilliseconds);
        }
        if (!Strings.isNullOrEmpty((String)(digest = (String)zookeeperProps.getValue(ZookeeperPropertyKey.DIGEST)))) {
            this.builder.authorization(ZookeeperPropertyKey.DIGEST.getKey(), digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return this.builder.build();
    }

    private void initCuratorClient(ZookeeperProperties zookeeperProps) {
        this.client.start();
        try {
            int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
            int maxRetries = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.MAX_RETRIES);
            if (!this.client.blockUntilConnected(retryIntervalMilliseconds * maxRetries, TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException | KeeperException.OperationTimeoutException ex) {
            CuratorZookeeperExceptionHandler.handleException((Exception)ex);
        }
    }

    public String get(String key) {
        return this.getDirectly(key);
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private void update(String key, String value) {
        try {
            this.client.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    private boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public String getSequentialId(String key, String value) {
        try {
            String path = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            return path.substring(key.length());
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    public void delete(String key) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        if (!this.caches.containsKey(key)) {
            CuratorCache curatorCache = CuratorCache.build((CuratorFramework)this.client, (String)key, (CuratorCache.Options[])new CuratorCache.Options[0]);
            this.start(curatorCache);
            this.caches.put(key, curatorCache);
        }
        CuratorCacheListener curatorCacheListener = CuratorCacheListener.builder().forTreeCache(this.client, (framework, treeCacheListener) -> {
            DataChangedEvent.Type changedType = this.getChangedType(treeCacheListener.getType());
            if (DataChangedEvent.Type.IGNORED != changedType) {
                listener.onChange(new DataChangedEvent(treeCacheListener.getData().getPath(), new String(treeCacheListener.getData().getData(), StandardCharsets.UTF_8), changedType));
            }
        }).build();
        this.caches.get(key).listenable().addListener((Object)curatorCacheListener);
    }

    private void start(CuratorCache cache) {
        try {
            cache.start();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private DataChangedEvent.Type getChangedType(TreeCacheEvent.Type type) {
        switch (type) {
            case NODE_ADDED: {
                return DataChangedEvent.Type.ADDED;
            }
            case NODE_UPDATED: {
                return DataChangedEvent.Type.UPDATED;
            }
            case NODE_REMOVED: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    public boolean tryLock(String key, long time, TimeUnit unit) {
        try {
            return this.getLock(key).acquire(time, unit);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void releaseLock(String key) {
        try {
            if (this.availableLock(key)) {
                this.locks.get(key).release();
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private InterProcessLock getLock(String key) {
        if (this.availableLock(key)) {
            return this.locks.get(key);
        }
        InterProcessSemaphoreMutex lock = new InterProcessSemaphoreMutex(this.client, key);
        this.locks.put(key, (InterProcessLock)lock);
        return lock;
    }

    private boolean availableLock(String key) {
        return Objects.nonNull(this.locks.get(key));
    }

    public void close() {
        this.caches.values().forEach(CuratorCache::close);
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void watchSessionConnection(InstanceDefinition instanceDefinition) {
        this.client.getConnectionStateListenable().addListener((Object)new SessionConnectionListener(instanceDefinition, this));
    }

    public String getType() {
        return "ZooKeeper";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

