/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.generator;

import lombok.Generated;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.node.WorkerIdNode;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ClusterWorkerIdGenerator
implements WorkerIdGenerator {
    private final ClusterPersistRepository repository;
    private final MetaDataPersistService metaDataPersistService;
    private final InstanceDefinition instanceDefinition;

    public long generate() {
        return this.metaDataPersistService.getComputeNodePersistService().loadInstanceWorkerId(this.instanceDefinition.getInstanceId().getId()).orElseGet(() -> this.reGenerate());
    }

    private Long reGenerate() {
        Long result = Long.valueOf(this.repository.getSequentialId(WorkerIdNode.getWorkerIdGeneratorPath(this.instanceDefinition.getInstanceId().getId()), ""));
        this.metaDataPersistService.getComputeNodePersistService().persistInstanceWorkerId(this.instanceDefinition.getInstanceId().getId(), result);
        return result;
    }

    @Generated
    public ClusterWorkerIdGenerator(ClusterPersistRepository repository, MetaDataPersistService metaDataPersistService, InstanceDefinition instanceDefinition) {
        this.repository = repository;
        this.metaDataPersistService = metaDataPersistService;
        this.instanceDefinition = instanceDefinition;
    }
}

