/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;

public final class StorageStatusNode {
    private static final String STORAGE_NODES = "storage_nodes";
    private static final String ATTRIBUTES_NODE = "attributes";

    public static String getRootPath() {
        return String.join((CharSequence)"/", "", "nodes", STORAGE_NODES, ATTRIBUTES_NODE);
    }

    public static String getStorageNodesDataSourcePath(String dataSourcePath) {
        return String.join((CharSequence)"/", "", "nodes", STORAGE_NODES, ATTRIBUTES_NODE, dataSourcePath);
    }

    public static String getStatusPath(QualifiedSchema schema) {
        return String.join((CharSequence)"/", "", "nodes", STORAGE_NODES, ATTRIBUTES_NODE, schema.toString());
    }

    public static Optional<QualifiedSchema> extractQualifiedSchema(String storageNodePath) {
        Pattern pattern = Pattern.compile(StorageStatusNode.getRootPath() + "/(\\S+)$", 2);
        Matcher matcher = pattern.matcher(storageNodePath);
        return matcher.find() ? Optional.of(new QualifiedSchema(matcher.group(1))) : Optional.empty();
    }

    @Generated
    private StorageStatusNode() {
    }
}

