/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.watcher;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.StateEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.WorkerIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class ComputeNodeStateChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(ComputeNode.getComputeNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        String instanceId = ComputeNode.getInstanceIdByAttributes((String)event.getKey());
        if (!Strings.isNullOrEmpty((String)instanceId)) {
            if (event.getKey().equals(ComputeNode.getInstanceStatusNodePath((String)instanceId))) {
                ArrayList<String> status = Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList<String>() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class);
                return Optional.of(new StateEvent(instanceId, status));
            }
            if (event.getKey().equals(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId))) {
                return Optional.of(new WorkerIdEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? null : Long.valueOf(event.getValue())));
            }
            if (event.getKey().equals(ComputeNode.getInstanceLabelsNodePath((String)instanceId))) {
                return Optional.of(new LabelsEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList<String>() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class)));
            }
            if (event.getKey().equals(ComputeNode.getInstanceXaRecoveryIdNodePath((String)instanceId))) {
                return Optional.of(new XaRecoveryIdEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? null : event.getValue()));
            }
        } else if (event.getKey().startsWith(ComputeNode.getOnlineInstanceNodePath())) {
            Optional instanceDefinition = ComputeNode.getInstanceDefinitionByInstanceOnlinePath((String)event.getKey());
            return instanceDefinition.isPresent() ? this.createInstanceEvent((InstanceDefinition)instanceDefinition.get(), event.getType()) : Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createInstanceEvent(InstanceDefinition instanceDefinition, DataChangedEvent.Type type) {
        if (type == DataChangedEvent.Type.ADDED) {
            return Optional.of(new InstanceOnlineEvent(instanceDefinition));
        }
        if (type == DataChangedEvent.Type.DELETED) {
            return Optional.of(new InstanceOfflineEvent(instanceDefinition));
        }
        return Optional.empty();
    }
}

