/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.watcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class PropertiesChangedWatcher
implements GovernanceWatcher<PropertiesChangedEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(GlobalNode.getPropsPath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.ADDED);
    }

    @Override
    public Optional<PropertiesChangedEvent> createGovernanceEvent(DataChangedEvent event) {
        return this.getWatchingKeys().contains(event.getKey()) ? Optional.of(new PropertiesChangedEvent((Properties)YamlEngine.unmarshal((String)event.getValue(), Properties.class))) : Optional.empty();
    }
}

