/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.watcher;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.GlobalRuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class GlobalRuleChangedWatcher
implements GovernanceWatcher<GlobalRuleConfigurationsChangedEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(GlobalNode.getGlobalRuleNode());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Collections.singleton(DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<GlobalRuleConfigurationsChangedEvent> createGovernanceEvent(DataChangedEvent event) {
        return this.getWatchingKeys().contains(event.getKey()) ? Optional.of(new GlobalRuleConfigurationsChangedEvent(this.getGlobalRuleConfigurations(event))) : Optional.empty();
    }

    private Collection<RuleConfiguration> getGlobalRuleConfigurations(DataChangedEvent event) {
        Collection globalRuleConfigs = (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class);
        Preconditions.checkState((!globalRuleConfigs.isEmpty() ? 1 : 0) != 0, (Object)"No available global rule to load for governance.");
        return new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(globalRuleConfigs);
    }
}

