/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.lock.InnerLockReleasedEvent;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.event.LockNotificationEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.event.LockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ShardingSphereDistributeLock
implements ShardingSphereLock {
    private final LockRegistryService lockService;
    private long lockTimeoutMilliseconds;
    private final Collection<String> lockedResources = new ArrayList<String>();

    public ShardingSphereDistributeLock(ClusterPersistRepository repository, long lockTimeoutMilliseconds) {
        this.lockService = new LockRegistryService(repository);
        this.lockTimeoutMilliseconds = lockTimeoutMilliseconds;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    public boolean tryLock(String lockName) {
        return this.lockService.tryLock(lockName, this.lockTimeoutMilliseconds) && this.lockService.checkLockAck(lockName, this.lockTimeoutMilliseconds);
    }

    public boolean tryLock(String lockName, long timeoutMilliseconds) {
        return this.lockService.tryLock(lockName, timeoutMilliseconds) && this.lockService.checkLockAck(lockName, timeoutMilliseconds);
    }

    public void releaseLock(String lockName) {
        this.lockService.releaseLock(lockName);
    }

    public boolean isLocked(String lockName) {
        return this.lockedResources.contains(lockName);
    }

    public long getDefaultTimeOut() {
        return this.lockTimeoutMilliseconds;
    }

    @Subscribe
    public void renew(PropertiesChangedEvent event) {
        this.lockTimeoutMilliseconds = (Long)new ConfigurationProperties(event.getProps()).getValue((Enum)ConfigurationPropertyKey.LOCK_WAIT_TIMEOUT_MILLISECONDS);
    }

    @Subscribe
    public void renew(LockNotificationEvent event) {
        this.lockedResources.add(event.getLockName());
        this.lockService.ackLock(event.getLockName());
    }

    @Subscribe
    public void renew(LockReleasedEvent event) {
        this.lockService.deleteLockAck(event.getLockName());
    }

    @Subscribe
    public void renew(InnerLockReleasedEvent event) {
        this.releaseInnerLock(event.getLockName());
    }

    private void releaseInnerLock(String lockName) {
        if (this.lockedResources.contains(lockName)) {
            this.lockedResources.remove(lockName);
            this.lockService.ackUnlock(lockName);
        }
    }
}

