/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.watcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.LockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.LockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.util.LockNodeUtil;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class GlobalLocksChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(GlobalLockNode.getGlobalLocksNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        Optional<String> lockedName = GlobalLockNode.getLockedKey(event.getKey());
        if (lockedName.isPresent()) {
            String[] schemaInstance = LockNodeUtil.parseLockName(lockedName.get());
            return this.handleGlobalLocksEvent(event.getType(), schemaInstance[0], schemaInstance[1]);
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> handleGlobalLocksEvent(DataChangedEvent.Type eventType, String schema, String instanceId) {
        if (DataChangedEvent.Type.ADDED == eventType) {
            return Optional.of(new LockedEvent(schema, instanceId));
        }
        if (DataChangedEvent.Type.DELETED == eventType) {
            return Optional.of(new LockReleasedEvent(schema, instanceId));
        }
        return Optional.empty();
    }
}

