/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.watcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.AckLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.AckLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.util.LockNodeUtil;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class GlobalAckChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(GlobalLockNode.getGlobalAckNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        String key = event.getKey();
        Optional<String> ackLockedName = GlobalLockNode.getAckLockedKey(key);
        if (ackLockedName.isPresent()) {
            String[] schemaInstance = LockNodeUtil.parseLockName(ackLockedName.get());
            return this.handleGlobalAckEvent(event.getType(), schemaInstance[0], schemaInstance[1]);
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> handleGlobalAckEvent(DataChangedEvent.Type eventType, String schema, String lockedInstanceId) {
        if (DataChangedEvent.Type.ADDED == eventType) {
            return Optional.of(new AckLockedEvent(schema, lockedInstanceId));
        }
        if (DataChangedEvent.Type.DELETED == eventType) {
            return Optional.of(new AckLockReleasedEvent(schema, lockedInstanceId));
        }
        return Optional.empty();
    }
}

