/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service;

import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.util.LockNodeUtil;

public final class GlobalLockNode {
    private static final String LOCK_ROOT = "lock";
    private static final String LOCK_SCOPE = "global";
    private static final String LOCKS_NODE = "locks";
    private static final String LOCKED_ACK_NODE = "ack";

    public static String getGlobalLocksNodePath() {
        return Joiner.on((String)"/").join((Object)"", (Object)LOCK_ROOT, new Object[]{LOCK_SCOPE, LOCKS_NODE});
    }

    public static String getGlobalAckNodePath() {
        return Joiner.on((String)"/").join((Object)"", (Object)LOCK_ROOT, new Object[]{LOCK_SCOPE, LOCKED_ACK_NODE});
    }

    public static String generateSchemaLockName(String schema, String instanceId) {
        return GlobalLockNode.getGlobalLocksNodePath() + "/" + LockNodeUtil.generateLockName(schema, instanceId);
    }

    public static String generateSchemaAckLockName(String schema, String lockedInstanceId) {
        return GlobalLockNode.getGlobalAckNodePath() + "/" + LockNodeUtil.generateLockName(schema, lockedInstanceId);
    }

    public static Optional<String> getLockedKey(String locksNodePath) {
        Pattern pattern = Pattern.compile(GlobalLockNode.getGlobalLocksNodePath() + "/(.+)$", 2);
        Matcher matcher = pattern.matcher(locksNodePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getAckLockedKey(String ackNodePath) {
        Pattern pattern = Pattern.compile(GlobalLockNode.getGlobalAckNodePath() + "/(.+)$", 2);
        Matcher matcher = pattern.matcher(ackNodePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    @Generated
    private GlobalLockNode() {
    }
}

