/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.ShardingSphereGlobalLock;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.ShardingSphereDistributeGlobalLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.AckLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.AckLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.LockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.event.LockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.util.LockNodeUtil;

public final class DistributeLockContext
implements LockContext {
    private final Map<String, ShardingSphereGlobalLock> globalLocks = new ConcurrentHashMap<String, ShardingSphereGlobalLock>();
    private final GlobalLockRegistryService globalLockService;
    private volatile ComputeNodeInstance currentInstance;
    private volatile Collection<ComputeNodeInstance> computeNodeInstances;

    public synchronized ShardingSphereLock getOrCreateSchemaLock(String schemaName) {
        Preconditions.checkNotNull((Object)schemaName, (Object)"Get or create schema lock args schema name can not be null.");
        ShardingSphereGlobalLock result = this.globalLocks.get(schemaName);
        if (null != result) {
            return result;
        }
        result = this.crateGlobalLock(this.getCurrentInstanceId());
        this.globalLocks.put(schemaName, result);
        return result;
    }

    private ShardingSphereGlobalLock crateGlobalLock(String ownerInstanceId) {
        return new ShardingSphereDistributeGlobalLock(this.currentInstance, ownerInstanceId, this.globalLockService, this.computeNodeInstances);
    }

    private String getCurrentInstanceId() {
        return this.currentInstance.getInstanceDefinition().getInstanceId().getId();
    }

    public Optional<ShardingSphereLock> getSchemaLock(String schemaName) {
        if (null == schemaName) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.globalLocks.get(schemaName));
    }

    public boolean isLockedSchema(String schemaName) {
        Preconditions.checkNotNull((Object)schemaName, (Object)"Is locked schema args schema name can not be null.");
        return this.getGlobalLock(schemaName).map(shardingSphereGlobalLock -> shardingSphereGlobalLock.isLocked(schemaName)).orElse(false);
    }

    private Optional<ShardingSphereGlobalLock> getGlobalLock(String schemaName) {
        return Optional.ofNullable(this.globalLocks.get(schemaName));
    }

    public void synchronizeGlobalLock(InstanceContext instanceContext) {
        this.init(instanceContext);
        Collection<String> allGlobalLock = this.globalLockService.synchronizeAllGlobalLock();
        if (allGlobalLock.isEmpty()) {
            this.globalLockService.initGlobalLockRoot();
            return;
        }
        for (String each : allGlobalLock) {
            String[] schemaInstanceId = LockNodeUtil.parseLockName(each);
            this.globalLocks.put(schemaInstanceId[0], this.crateGlobalLock(schemaInstanceId[1]));
        }
    }

    private void init(InstanceContext instanceContext) {
        this.currentInstance = instanceContext.getInstance();
        this.computeNodeInstances = instanceContext.getComputeNodeInstances();
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    private boolean isSameInstanceId(String instanceId) {
        return this.getCurrentInstanceId().equals(instanceId);
    }

    @Subscribe
    public synchronized void renew(LockedEvent event) {
        ShardingSphereGlobalLock lock;
        String schema = event.getSchema();
        String ownerInstanceId = event.getOwnerInstanceId();
        if (this.isSameInstanceId(ownerInstanceId)) {
            return;
        }
        Optional<ShardingSphereGlobalLock> globalLock = this.getGlobalLock(schema);
        if (globalLock.isPresent()) {
            lock = globalLock.get();
        } else {
            lock = this.crateGlobalLock(ownerInstanceId);
            this.globalLocks.put(schema, lock);
        }
        lock.ackLock(schema, this.getCurrentInstanceId());
    }

    @Subscribe
    public synchronized void renew(LockReleasedEvent event) {
        String schema = event.getSchema();
        String ownerInstanceId = event.getOwnerInstanceId();
        if (this.isSameInstanceId(ownerInstanceId)) {
            ShardingSphereGlobalLock shardingSphereGlobalLock2 = this.globalLocks.get(schema);
            if (null == shardingSphereGlobalLock2) {
                return;
            }
            shardingSphereGlobalLock2.releaseLockedState(schema);
            this.globalLocks.remove(schema);
            return;
        }
        this.getGlobalLock(schema).ifPresent(shardingSphereGlobalLock -> {
            shardingSphereGlobalLock.releaseAckLock(schema, this.getCurrentInstanceId());
            this.globalLocks.remove(schema);
        });
    }

    @Subscribe
    public synchronized void renew(AckLockedEvent event) {
        String schema = event.getSchema();
        String lockedInstanceId = event.getLockedInstanceId();
        this.getGlobalLock(schema).ifPresent(shardingSphereGlobalLock -> shardingSphereGlobalLock.addLockedInstance(lockedInstanceId));
    }

    @Subscribe
    public synchronized void renew(AckLockReleasedEvent event) {
        String schema = event.getSchema();
        String lockedInstanceId = event.getLockedInstanceId();
        if (this.isSameInstanceId(lockedInstanceId)) {
            this.globalLocks.remove(schema);
            return;
        }
        this.getGlobalLock(schema).ifPresent(shardingSphereGlobalLock -> shardingSphereGlobalLock.addLockedInstance(lockedInstanceId));
    }

    @Generated
    public DistributeLockContext(GlobalLockRegistryService globalLockService) {
        this.globalLockService = globalLockService;
    }
}

