/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.infra.storage.StorageNodeDataSource;
import org.apache.shardingsphere.infra.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.GlobalRuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.SchemaVersionChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.StateEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.WorkerIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.PrimaryStateChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class ClusterContextManagerCoordinator {
    private final MetaDataPersistService metaDataPersistService;
    private final ContextManager contextManager;
    private final RegistryCenter registryCenter;

    public ClusterContextManagerCoordinator(MetaDataPersistService metaDataPersistService, ContextManager contextManager, RegistryCenter registryCenter) {
        this.metaDataPersistService = metaDataPersistService;
        this.contextManager = contextManager;
        this.registryCenter = registryCenter;
        ShardingSphereEventBus.getInstance().register((Object)this);
        this.buildSpecialRules();
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) throws SQLException {
        this.persistSchema(event.getSchemaName());
        this.contextManager.addSchema(event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        this.contextManager.deleteSchema(event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        this.contextManager.alterProperties(event.getProps());
    }

    @Subscribe
    public synchronized void renew(SchemaChangedEvent event) {
        this.contextManager.alterSchema(event.getSchemaName(), event.getChangedTableMetaData(), event.getDeletedTable());
    }

    @Subscribe
    public synchronized void renew(RuleConfigurationsChangedEvent event) {
        if (this.metaDataPersistService.getSchemaVersionPersistService().isActiveVersion(event.getSchemaName(), event.getSchemaVersion())) {
            this.contextManager.alterRuleConfiguration(event.getSchemaName(), event.getRuleConfigurations());
            this.buildSpecialRules();
        }
    }

    @Subscribe
    public synchronized void renew(DataSourceChangedEvent event) {
        if (this.metaDataPersistService.getSchemaVersionPersistService().isActiveVersion(event.getSchemaName(), event.getSchemaVersion())) {
            this.contextManager.alterDataSourceConfiguration(event.getSchemaName(), event.getDataSourcePropertiesMap());
            this.buildSpecialRules();
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent event) {
        QualifiedSchema qualifiedSchema = event.getQualifiedSchema();
        ((ShardingSphereMetaData)this.contextManager.getMetaDataContexts().getMetaDataMap().get(qualifiedSchema.getSchemaName())).getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> ((StatusContainedRule)each).updateStatus((DataSourceStatusChangedEvent)new DataSourceNameDisabledEvent(qualifiedSchema, event.isDisabled())));
    }

    @Subscribe
    public synchronized void renew(PrimaryStateChangedEvent event) {
        QualifiedSchema qualifiedSchema = event.getQualifiedSchema();
        ((ShardingSphereMetaData)this.contextManager.getMetaDataContexts().getMetaDataMap().get(qualifiedSchema.getSchemaName())).getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> ((StatusContainedRule)each).updateStatus((DataSourceStatusChangedEvent)new PrimaryDataSourceChangedEvent(qualifiedSchema)));
    }

    @Subscribe
    public synchronized void renew(GlobalRuleConfigurationsChangedEvent event) {
        this.contextManager.alterGlobalRuleConfiguration(event.getRuleConfigurations());
    }

    @Subscribe
    public synchronized void renew(StateEvent event) {
        this.contextManager.getInstanceContext().updateInstanceStatus(event.getInstanceId(), event.getStatus());
    }

    @Subscribe
    public synchronized void renew(WorkerIdEvent event) {
        if (this.contextManager.getInstanceContext().getInstance().getInstanceDefinition().getInstanceId().getId().equals(event.getInstanceId())) {
            this.contextManager.getInstanceContext().updateWorkerId(event.getWorkerId());
        }
    }

    @Subscribe
    public synchronized void renew(LabelsEvent event) {
        this.contextManager.getInstanceContext().updateLabel(event.getInstanceId(), event.getLabels());
    }

    @Subscribe
    public synchronized void renew(XaRecoveryIdEvent event) {
        if (this.contextManager.getInstanceContext().getInstance().getInstanceDefinition().getInstanceId().getId().equals(event.getInstanceId())) {
            this.contextManager.getInstanceContext().updateXaRecoveryId(event.getXaRecoveryId());
            this.contextManager.renewAllTransactionContext();
        }
    }

    @Subscribe
    public synchronized void renew(InstanceOnlineEvent event) {
        ComputeNodeInstance instance = this.metaDataPersistService.getComputeNodePersistService().loadComputeNodeInstance(event.getInstanceDefinition());
        this.contextManager.getInstanceContext().addComputeNodeInstance(instance);
    }

    @Subscribe
    public synchronized void renew(InstanceOfflineEvent event) {
        this.contextManager.getInstanceContext().deleteComputeNodeInstance(this.metaDataPersistService.getComputeNodePersistService().loadComputeNodeInstance(event.getInstanceDefinition()));
    }

    @Subscribe
    public synchronized void renew(SchemaVersionChangedEvent event) {
        Map dataSourcePropertiesMap = this.metaDataPersistService.getDataSourceService().load(event.getSchemaName(), event.getActiveVersion());
        Collection ruleConfigs = this.metaDataPersistService.getSchemaRuleService().load(event.getSchemaName(), event.getActiveVersion());
        this.contextManager.alterDataSourceAndRuleConfiguration(event.getSchemaName(), dataSourcePropertiesMap, ruleConfigs);
    }

    private void persistSchema(String schemaName) {
        if (!this.metaDataPersistService.getDataSourceService().isExisted(schemaName)) {
            this.metaDataPersistService.getDataSourceService().persist(schemaName, new LinkedHashMap());
        }
        if (!this.metaDataPersistService.getSchemaRuleService().isExisted(schemaName)) {
            this.metaDataPersistService.getSchemaRuleService().persist(schemaName, new LinkedList());
        }
    }

    private void buildSpecialRules() {
        this.contextManager.getMetaDataContexts().getMetaDataMap().forEach((key, value) -> value.getRuleMetaData().getRules().forEach(each -> {
            if (each instanceof StatusContainedRule) {
                this.disableDataSources((StatusContainedRule)each);
            } else if (each instanceof InstanceAwareRule) {
                ((InstanceAwareRule)each).setInstanceContext(this.contextManager.getInstanceContext());
            }
        }));
    }

    private void disableDataSources(StatusContainedRule rule) {
        Map<String, StorageNodeDataSource> storageNodes = this.registryCenter.getStorageNodeStatusService().loadStorageNodes();
        Map<String, StorageNodeDataSource> disableDataSources = storageNodes.entrySet().stream().filter(entry -> StorageNodeStatus.DISABLED.name().toLowerCase().equals(((StorageNodeDataSource)entry.getValue()).getStatus())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        disableDataSources.entrySet().stream().forEach(entry -> rule.updateStatus((DataSourceStatusChangedEvent)new DataSourceNameDisabledEvent(new QualifiedSchema((String)entry.getKey()), true)));
    }
}

