/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.rule;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.spi.AuthorityProvideAlgorithm;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class AuthorityRule
implements GlobalRule {
    private final AuthorityProvideAlgorithm provider;
    private final Collection<ShardingSphereUser> users;

    public AuthorityRule(AuthorityRuleConfiguration config, Map<String, ShardingSphereMetaData> metaDataMap) {
        this.provider = (AuthorityProvideAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)config.getProvider(), AuthorityProvideAlgorithm.class);
        this.provider.init(metaDataMap, config.getUsers());
        this.users = config.getUsers();
    }

    public Optional<ShardingSpherePrivileges> findPrivileges(Grantee grantee) {
        return this.provider.findPrivileges(grantee);
    }

    public void refresh(Map<String, ShardingSphereMetaData> metaDataMap, Collection<ShardingSphereUser> users) {
        this.provider.refresh(metaDataMap, users);
    }

    public Optional<ShardingSphereUser> findUser(Grantee grantee) {
        return this.users.stream().filter(user -> user.getGrantee().equals((Object)grantee)).findFirst();
    }

    public String getType() {
        return AuthorityRule.class.getSimpleName();
    }

    static {
        ShardingSphereServiceLoader.register(AuthorityProvideAlgorithm.class);
    }
}

