/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.schema;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.provider.schema.builder.SchemaPrivilegeBuilder;
import org.apache.shardingsphere.authority.spi.AuthorityProvideAlgorithm;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class SchemaPrivilegesPermittedAuthorityProviderAlgorithm
implements AuthorityProvideAlgorithm {
    public static final String PROP_USER_SCHEMA_MAPPINGS = "user-schema-mappings";
    private final Map<ShardingSphereUser, ShardingSpherePrivileges> userPrivilegeMap = new ConcurrentHashMap<ShardingSphereUser, ShardingSpherePrivileges>();
    private Properties props;

    public void setProps(Properties props) {
        this.props = props;
    }

    public Properties getProps() {
        return this.props;
    }

    public void init(Map<String, ShardingSphereMetaData> metaDataMap, Collection<ShardingSphereUser> users) {
        this.userPrivilegeMap.putAll(SchemaPrivilegeBuilder.build(users, this.props));
    }

    public void refresh(Map<String, ShardingSphereMetaData> metaDataMap, Collection<ShardingSphereUser> users) {
        this.userPrivilegeMap.putAll(SchemaPrivilegeBuilder.build(users, this.props));
    }

    public Optional<ShardingSpherePrivileges> findPrivileges(Grantee grantee) {
        return this.userPrivilegeMap.keySet().stream().filter(each -> each.getGrantee().equals((Object)grantee)).findFirst().map(this.userPrivilegeMap::get);
    }

    public String getType() {
        return "SCHEMA_PRIVILEGES_PERMITTED";
    }
}

