/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.model.privilege.database;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.TablePrivileges;

public final class SchemaPrivileges {
    private final String name;
    private final Collection<PrivilegeType> globalPrivileges = new CopyOnWriteArraySet<PrivilegeType>();
    private final Map<String, TablePrivileges> specificPrivileges = new ConcurrentHashMap<String, TablePrivileges>();

    public boolean hasPrivileges(Collection<PrivilegeType> privileges) {
        return this.hasGlobalPrivileges(privileges);
    }

    public boolean hasPrivileges(String table, Collection<PrivilegeType> privileges) {
        return this.hasGlobalPrivileges(privileges) || this.hasSpecificPrivileges(table, privileges);
    }

    private boolean hasGlobalPrivileges(Collection<PrivilegeType> privileges) {
        return this.globalPrivileges.containsAll(privileges);
    }

    private boolean hasSpecificPrivileges(String table, Collection<PrivilegeType> privileges) {
        return this.specificPrivileges.containsKey(table) && this.specificPrivileges.get(table).hasPrivileges(this.getSpecificPrivileges(privileges));
    }

    private Collection<PrivilegeType> getSpecificPrivileges(Collection<PrivilegeType> privileges) {
        return privileges.stream().filter(each -> !this.globalPrivileges.contains(each)).collect(Collectors.toList());
    }

    @Generated
    public SchemaPrivileges(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Collection<PrivilegeType> getGlobalPrivileges() {
        return this.globalPrivileges;
    }

    @Generated
    public Map<String, TablePrivileges> getSpecificPrivileges() {
        return this.specificPrivileges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaPrivileges)) {
            return false;
        }
        SchemaPrivileges other = (SchemaPrivileges)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Collection<PrivilegeType> this$globalPrivileges = this.getGlobalPrivileges();
        Collection<PrivilegeType> other$globalPrivileges = other.getGlobalPrivileges();
        if (this$globalPrivileges == null ? other$globalPrivileges != null : !((Object)this$globalPrivileges).equals(other$globalPrivileges)) {
            return false;
        }
        Map<String, TablePrivileges> this$specificPrivileges = this.getSpecificPrivileges();
        Map<String, TablePrivileges> other$specificPrivileges = other.getSpecificPrivileges();
        return !(this$specificPrivileges == null ? other$specificPrivileges != null : !((Object)this$specificPrivileges).equals(other$specificPrivileges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Collection<PrivilegeType> $globalPrivileges = this.getGlobalPrivileges();
        result = result * 59 + ($globalPrivileges == null ? 43 : ((Object)$globalPrivileges).hashCode());
        Map<String, TablePrivileges> $specificPrivileges = this.getSpecificPrivileges();
        result = result * 59 + ($specificPrivileges == null ? 43 : ((Object)$specificPrivileges).hashCode());
        return result;
    }
}

