/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.statement;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractStatementAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.MasterSlaveConnection;

public final class MasterSlaveStatement
extends AbstractStatementAdapter {
    private final MasterSlaveConnection connection;
    private final MasterSlaveRouter masterSlaveRouter;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Collection<Statement> routedStatements = new LinkedList<Statement>();

    public MasterSlaveStatement(MasterSlaveConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public MasterSlaveStatement(MasterSlaveConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public MasterSlaveStatement(MasterSlaveConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.masterSlaveRouter = new MasterSlaveRouter(connection.getMasterSlaveDataSource().getMasterSlaveRule(), ((Boolean)connection.getMasterSlaveDataSource().getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue());
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.clearPrevious();
        Collection dataSourceNames = this.masterSlaveRouter.route(sql);
        Preconditions.checkState((1 == dataSourceNames.size() ? 1 : 0) != 0, (Object)"Cannot support executeQuery for DML or DDL");
        Statement statement = this.connection.getConnection((String)dataSourceNames.iterator().next()).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.routedStatements.add(statement);
        return statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.clearPrevious();
        int result = 0;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.clearPrevious();
        int result = 0;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql, autoGeneratedKeys);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.clearPrevious();
        int result = 0;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql, columnIndexes);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.clearPrevious();
        int result = 0;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql, columnNames);
        }
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.clearPrevious();
        boolean result = false;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.clearPrevious();
        boolean result = false;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql, autoGeneratedKeys);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.clearPrevious();
        boolean result = false;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql, columnIndexes);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.clearPrevious();
        boolean result = false;
        for (String each : this.masterSlaveRouter.route(sql)) {
            Statement statement = this.connection.getConnection(each).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql, columnNames);
        }
        return result;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().getGeneratedKeys();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().getResultSet();
    }

    private void clearPrevious() throws SQLException {
        for (Statement each : this.routedStatements) {
            each.close();
        }
        this.routedStatements.clear();
    }

    @Override
    public boolean isAccumulate() {
        return false;
    }

    @Override
    public MasterSlaveConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.routedStatements;
    }
}

