/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset;

import com.google.common.collect.Lists;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.ResultSetUtil;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedDatabaseMetaDataResultSet;

public final class DatabaseMetaDataResultSet
extends AbstractUnsupportedDatabaseMetaDataResultSet {
    private static final String TABLE_NAME = "TABLE_NAME";
    private final int type;
    private final int concurrency;
    private final ShardingRule shardingRule;
    private final ResultSetMetaData resultSetMetaData;
    private final Map<String, Integer> columnLabelIndexMap;
    private final Iterator<DatabaseMetaDataObject> databaseMetaDataObjectIterator;
    private volatile boolean closed;
    private DatabaseMetaDataObject currentDatabaseMetaDataObject;

    public DatabaseMetaDataResultSet(ResultSet resultSet, ShardingRule shardingRule) throws SQLException {
        this.type = resultSet.getType();
        this.concurrency = resultSet.getConcurrency();
        this.shardingRule = shardingRule;
        this.resultSetMetaData = resultSet.getMetaData();
        this.columnLabelIndexMap = this.initIndexMap();
        this.databaseMetaDataObjectIterator = this.initIterator(resultSet);
    }

    private Map<String, Integer> initIndexMap() throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>(this.resultSetMetaData.getColumnCount());
        for (int i = 1; i <= this.resultSetMetaData.getColumnCount(); ++i) {
            result.put(this.resultSetMetaData.getColumnLabel(i), i);
        }
        return result;
    }

    private Iterator<DatabaseMetaDataObject> initIterator(ResultSet resultSet) throws SQLException {
        int tableNameColumnIndex;
        ArrayList result = Lists.newArrayList();
        HashSet<DatabaseMetaDataObject> removeDuplicationSet = new HashSet<DatabaseMetaDataObject>();
        int n = tableNameColumnIndex = this.columnLabelIndexMap.containsKey(TABLE_NAME) ? this.columnLabelIndexMap.get(TABLE_NAME) : -1;
        while (resultSet.next()) {
            DatabaseMetaDataObject databaseMetaDataObject = this.generateDatabaseMetaDataObject(tableNameColumnIndex, resultSet);
            if (removeDuplicationSet.contains(databaseMetaDataObject)) continue;
            result.add(databaseMetaDataObject);
            removeDuplicationSet.add(databaseMetaDataObject);
        }
        return result.iterator();
    }

    private DatabaseMetaDataObject generateDatabaseMetaDataObject(int tableNameColumnIndex, ResultSet resultSet) throws SQLException {
        DatabaseMetaDataObject result = new DatabaseMetaDataObject(this.resultSetMetaData.getColumnCount());
        for (int i = 1; i <= this.columnLabelIndexMap.size(); ++i) {
            if (tableNameColumnIndex == i) {
                String tableName = resultSet.getString(i);
                Collection logicTableNames = this.shardingRule.getLogicTableNames(tableName);
                result.addObject(0 == logicTableNames.size() ? tableName : (String)logicTableNames.iterator().next());
                continue;
            }
            result.addObject(resultSet.getObject(i));
        }
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.databaseMetaDataObjectIterator.hasNext()) {
            this.currentDatabaseMetaDataObject = this.databaseMetaDataObjectIterator.next();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.checkClosed();
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (String)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Boolean)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Byte)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Short)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Integer)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Long)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return ((Float)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Double)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (byte[])ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Date)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Time)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Timestamp)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return this.currentDatabaseMetaDataObject.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.columnLabelIndexMap.containsKey(columnLabel)) {
            throw new SQLException(String.format("Can not find columnLabel %s", columnLabel));
        }
        return this.columnLabelIndexMap.get(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet has closed.");
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.resultSetMetaData.getColumnCount()) {
            throw new SQLException(String.format("ColumnIndex %d out of range from %d to %d", columnIndex, 1, this.resultSetMetaData.getColumnCount()));
        }
    }

    private final class DatabaseMetaDataObject {
        private final ArrayList<Object> objects;

        private DatabaseMetaDataObject(int columnCount) {
            this.objects = new ArrayList(columnCount);
        }

        public void addObject(Object object) {
            this.objects.add(object);
        }

        public Object getObject(int index) {
            return this.objects.get(index - 1);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseMetaDataObject)) {
                return false;
            }
            DatabaseMetaDataObject other = (DatabaseMetaDataObject)o;
            ArrayList<Object> this$objects = this.objects;
            ArrayList<Object> other$objects = other.objects;
            return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ArrayList<Object> $objects = this.objects;
            result = result * 59 + ($objects == null ? 0 : ((Object)$objects).hashCode());
            return result;
        }
    }
}

