/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.execute.ShardingExecuteEngine;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataConnectionManager;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataInitializer;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.cache.ParsingResultCache;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.metadata.CachedDatabaseMetaData;
import org.apache.shardingsphere.shardingjdbc.jdbc.metadata.JDBCTableMetaDataConnectionManager;

public final class ShardingContext
implements AutoCloseable {
    private final DatabaseMetaData cachedDatabaseMetaData;
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;
    private final ShardingExecuteEngine executeEngine;
    private final ShardingProperties shardingProperties;
    private final ShardingMetaData metaData;
    private final ParsingResultCache parsingResultCache;

    public ShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, Properties props) throws SQLException {
        this.shardingRule = shardingRule;
        this.cachedDatabaseMetaData = this.createCachedDatabaseMetaData(dataSourceMap);
        this.databaseType = databaseType;
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executeEngine = new ShardingExecuteEngine(executorSize);
        ShardingDataSourceMetaData shardingDataSourceMetaData = new ShardingDataSourceMetaData(this.getDataSourceURLs(dataSourceMap), shardingRule, databaseType);
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(this.getTableMetaDataInitializer(dataSourceMap, shardingDataSourceMetaData).load(shardingRule));
        this.metaData = new ShardingMetaData(shardingDataSourceMetaData, shardingTableMetaData);
        this.parsingResultCache = new ParsingResultCache();
    }

    private DatabaseMetaData createCachedDatabaseMetaData(Map<String, DataSource> dataSourceMap) throws SQLException {
        try (Connection connection = dataSourceMap.values().iterator().next().getConnection();){
            CachedDatabaseMetaData cachedDatabaseMetaData = new CachedDatabaseMetaData(connection.getMetaData(), dataSourceMap, this.shardingRule);
            return cachedDatabaseMetaData;
        }
    }

    private Map<String, String> getDataSourceURLs(Map<String, DataSource> dataSourceMap) throws SQLException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            result.put(entry.getKey(), this.getDataSourceURL(entry.getValue()));
        }
        return result;
    }

    private String getDataSourceURL(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            String string = connection.getMetaData().getURL();
            return string;
        }
    }

    private TableMetaDataInitializer getTableMetaDataInitializer(Map<String, DataSource> dataSourceMap, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        return new TableMetaDataInitializer(shardingDataSourceMetaData, this.executeEngine, (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(dataSourceMap), ((Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), ((Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.CHECK_TABLE_METADATA_ENABLED)).booleanValue());
    }

    @Override
    public void close() {
        this.executeEngine.close();
    }

    public DatabaseMetaData getCachedDatabaseMetaData() {
        return this.cachedDatabaseMetaData;
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ShardingExecuteEngine getExecuteEngine() {
        return this.executeEngine;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }

    public ShardingMetaData getMetaData() {
        return this.metaData;
    }

    public ParsingResultCache getParsingResultCache() {
        return this.parsingResultCache;
    }
}

