/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.adapter;

import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.invocation.JdbcMethodInvocation;

public abstract class WrapperAdapter
implements Wrapper {
    private final Collection<JdbcMethodInvocation> jdbcMethodInvocations = new ArrayList<JdbcMethodInvocation>();

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(String.format("[%s] cannot be unwrapped as [%s]", this.getClass().getName(), iface.getName()));
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    public final void recordMethodInvocation(Class<?> targetClass, String methodName, Class<?>[] argumentTypes, Object[] arguments) {
        this.jdbcMethodInvocations.add(new JdbcMethodInvocation(targetClass.getMethod(methodName, argumentTypes), arguments));
    }

    public final void replayMethodsInvocation(Object target) {
        for (JdbcMethodInvocation each : this.jdbcMethodInvocations) {
            each.invoke(target);
        }
    }
}

