/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.validator;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOCube;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.rules.LogicalRelationalNodeValidator;

public final class BlackAndWhitelistValidator
implements LogicalRelationalNodeValidator {
    private final PigContext pigContext;
    private final OperatorPlan operatorPlan;

    public BlackAndWhitelistValidator(PigContext pigContext, OperatorPlan operatorPlan) {
        this.pigContext = pigContext;
        this.operatorPlan = operatorPlan;
    }

    public void validate() throws FrontendException {
        BlackAndWhitelistVisitor visitor = new BlackAndWhitelistVisitor(this.operatorPlan);
        visitor.visit();
    }

    private class BlackAndWhitelistVisitor
    extends LogicalRelationalNodesVisitor {
        private static final int ERROR_CODE = 1855;
        private final Splitter splitter;
        private final Set<String> blacklist;
        private final Set<String> whitelist;

        protected BlackAndWhitelistVisitor(OperatorPlan plan) throws FrontendException {
            super(plan, new DepthFirstWalker(plan));
            this.blacklist = Sets.newHashSet();
            this.whitelist = Sets.newHashSet();
            this.splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            this.init();
        }

        private void init() {
            String whitelistConfig;
            String blacklistConfig = BlackAndWhitelistValidator.this.pigContext.getProperties().getProperty("pig.blacklist");
            if (blacklistConfig != null) {
                Iterable iter = this.splitter.split((CharSequence)blacklistConfig);
                for (String elem : iter) {
                    this.blacklist.add(elem.toLowerCase());
                }
            }
            if ((whitelistConfig = BlackAndWhitelistValidator.this.pigContext.getProperties().getProperty("pig.whitelist")) != null) {
                Iterable iter = this.splitter.split((CharSequence)whitelistConfig);
                for (String elem : iter) {
                    String lElem = elem.toLowerCase();
                    if (this.blacklist.contains(lElem)) {
                        throw new IllegalStateException("Conflict between whitelist and blacklist. '" + elem + "' appears in both.");
                    }
                    this.whitelist.add(lElem);
                }
            }
        }

        private void check(String operator) throws FrontendException {
            if (this.whitelist != null && this.whitelist.size() > 0 && !this.whitelist.contains(operator)) {
                throw new FrontendException(operator + " is disabled. ", 1855);
            }
            if (this.blacklist != null && this.blacklist.size() > 0 && this.blacklist.contains(operator)) {
                throw new FrontendException(operator + " is disabled. ", 1855);
            }
        }

        public void visit(LOLoad load) throws FrontendException {
            this.check("load");
        }

        public void visit(LOFilter filter) throws FrontendException {
            this.check("filter");
        }

        public void visit(LOStore store) throws FrontendException {
            this.check("store");
        }

        public void visit(LOJoin join) throws FrontendException {
            this.check("join");
        }

        public void visit(LOForEach foreach) throws FrontendException {
            this.check("foreach");
        }

        public void visit(LOGenerate gen) throws FrontendException {
        }

        public void visit(LOInnerLoad load) throws FrontendException {
        }

        public void visit(LOCube cube) throws FrontendException {
            this.check("cube");
        }

        public void visit(LOCogroup loCogroup) throws FrontendException {
            this.check("group");
            this.check("cogroup");
        }

        public void visit(LOSplit loSplit) throws FrontendException {
            this.check("split");
        }

        public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
        }

        public void visit(LOUnion loUnion) throws FrontendException {
            this.check("union");
        }

        public void visit(LOSort loSort) throws FrontendException {
            this.check("order");
        }

        public void visit(LORank loRank) throws FrontendException {
            this.check("rank");
        }

        public void visit(LODistinct loDistinct) throws FrontendException {
            this.check("distinct");
        }

        public void visit(LOLimit loLimit) throws FrontendException {
            this.check("limit");
        }

        public void visit(LOCross loCross) throws FrontendException {
            this.check("cross");
        }

        public void visit(LOStream loStream) throws FrontendException {
            this.check("stream");
        }

        public void visit(LONative nativeMR) throws FrontendException {
            this.check("mapreduce");
        }
    }
}

