/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import java.util.Iterator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.scripting.jruby.PigJrubyLibrary;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"DataBag"}, include={"Enumerable"})
public class RubyDataBag
extends RubyObject
implements Iterable<Tuple> {
    private static final long serialVersionUID = 1L;
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private static BagFactory mBagFactory = BagFactory.getInstance();
    private DataBag internalDB;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyDataBag(runtime, klass);
        }
    };

    public DataBag getBag() {
        return this.internalDB;
    }

    public static RubyClass define(Ruby runtime) {
        RubyClass result = runtime.defineClass("DataBag", runtime.getObject(), ALLOCATOR);
        result.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyDataBag;
            }
        };
        result.includeModule((IRubyObject)runtime.getEnumerable());
        result.defineAnnotatedMethods(RubyDataBag.class);
        return result;
    }

    protected RubyDataBag(Ruby ruby, RubyClass rc) {
        super(ruby, rc);
        this.internalDB = mBagFactory.newDefaultBag();
    }

    protected RubyDataBag(Ruby ruby, RubyClass rc, DataBag db) {
        super(ruby, rc);
        this.internalDB = db;
    }

    @JRubyMethod
    public RubyDataBag initialize() {
        this.internalDB = mBagFactory.newDefaultBag();
        return this;
    }

    @JRubyMethod
    public RubyDataBag initialize(IRubyObject arg) {
        if (!(arg instanceof RubyDataBag)) {
            throw new IllegalArgumentException("Bag argument passed to DataBag initializer");
        }
        this.internalDB = ((RubyDataBag)arg).getBag();
        return this;
    }

    @JRubyMethod
    public void clear() {
        this.internalDB.clear();
    }

    @JRubyMethod(name={"distinct?", "is_distinct?"})
    public RubyBoolean isDistinct(ThreadContext context) {
        return RubyBoolean.newBoolean((Ruby)context.getRuntime(), (boolean)this.internalDB.isDistinct());
    }

    @JRubyMethod(name={"sorted?", "is_sorted?"})
    public RubyBoolean isSorted(ThreadContext context) {
        return RubyBoolean.newBoolean((Ruby)context.getRuntime(), (boolean)this.internalDB.isSorted());
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size(ThreadContext context) {
        return RubyFixnum.newFixnum((Ruby)context.getRuntime(), (long)this.internalDB.size());
    }

    @JRubyMethod(required=1, rest=true)
    public void add(ThreadContext context, IRubyObject[] args) throws ExecException {
        for (IRubyObject arg : args) {
            if (arg instanceof RubyDataBag) {
                for (Tuple t : (RubyDataBag)arg) {
                    this.internalDB.add(t);
                }
                continue;
            }
            if (arg instanceof RubyArray) {
                this.internalDB.add(PigJrubyLibrary.rubyToPig((RubyArray)arg));
                continue;
            }
            this.internalDB.add(mTupleFactory.newTuple(PigJrubyLibrary.rubyToPig(arg)));
        }
    }

    @JRubyMethod
    public RubyDataBag clone(ThreadContext context) {
        DataBag b = mBagFactory.newDefaultBag();
        for (Tuple t : this) {
            b.add(t);
        }
        Ruby runtime = context.getRuntime();
        return new RubyDataBag(runtime, runtime.getClass("DataBag"), b);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean isEmpty(ThreadContext context) {
        return RubyBoolean.newBoolean((Ruby)context.getRuntime(), (this.internalDB.size() == 0L ? 1 : 0) != 0);
    }

    @JRubyMethod(name={"inspect", "to_s", "to_string"}, optional=1)
    public RubyString inspect(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        StringBuilder sb = new StringBuilder();
        sb.append("[DataBag: size: ").append(this.internalDB.size());
        if (args.length > 0 && args[0].isTrue()) {
            sb.append(" = ").append(this.internalDB.toString());
        }
        sb.append("]");
        return RubyString.newString((Ruby)runtime, (CharSequence)sb);
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.internalDB.iterator();
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) throws ExecException {
        Ruby runtime = context.getRuntime();
        if (!block.isGiven()) {
            return PigJrubyLibrary.enumeratorize(runtime, (IRubyObject)this, "each");
        }
        for (Tuple t : this) {
            block.yield(context, (IRubyObject)PigJrubyLibrary.pigToRuby(runtime, t));
        }
        return context.nil;
    }

    @JRubyMethod(name={"flat_each", "flatten"})
    public IRubyObject flatten(ThreadContext context, Block block) throws ExecException {
        Ruby runtime = context.getRuntime();
        if (!block.isGiven()) {
            return PigJrubyLibrary.enumeratorize(runtime, (IRubyObject)this, "flatten");
        }
        for (Tuple t : this) {
            block.yield(context, PigJrubyLibrary.pigToRuby(runtime, t.get(0)));
        }
        return context.nil;
    }
}

