/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.io.IOException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.pig.OverwritableStoreFunc;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;

public class InputOutputFileValidatorVisitor
extends LogicalRelationalNodesVisitor {
    private PigContext pigCtx;

    public InputOutputFileValidatorVisitor(OperatorPlan plan, PigContext pigContext) throws FrontendException {
        super(plan, new DepthFirstWalker(plan));
        this.pigCtx = pigContext;
    }

    public void visit(LOStore store) throws FrontendException {
        Job dummyJob;
        StoreFuncInterface sf = store.getStoreFunc();
        String outLoc = store.getOutputSpec().getFileName();
        int errCode = 2116;
        String validationErrStr = "Output Location Validation Failed for: '" + outLoc;
        try {
            if (store.getSchema() != null) {
                sf.checkSchema(new ResourceSchema(store.getSchema(), store.getSortInfo()));
            }
            dummyJob = new Job(ConfigurationUtil.toConfiguration(this.pigCtx.getProperties()));
            sf.setStoreLocation(outLoc, dummyJob);
        }
        catch (Exception ioe) {
            if (ioe instanceof PigException) {
                errCode = ((PigException)ioe).getErrorCode();
            }
            String exceptionMsg = ioe.getMessage();
            validationErrStr = validationErrStr + (exceptionMsg == null ? "" : " More info to follow:\n" + exceptionMsg);
            throw new VisitorException(store, validationErrStr, errCode, this.pigCtx.getErrorSource(), ioe);
        }
        validationErrStr = validationErrStr + " More info to follow:\n";
        try {
            sf.getOutputFormat().checkOutputSpecs((JobContext)dummyJob);
        }
        catch (IOException ioe) {
            byte errSrc = this.pigCtx.getErrorSource();
            switch (errSrc) {
                case 4: {
                    errCode = 2002;
                    break;
                }
                case 16: {
                    errCode = 6000;
                    break;
                }
                case 8: {
                    errCode = 4000;
                }
            }
            boolean shouldThrowException = true;
            if (sf instanceof OverwritableStoreFunc && ((OverwritableStoreFunc)((Object)sf)).shouldOverwrite() && (ioe instanceof org.apache.hadoop.mapred.FileAlreadyExistsException || ioe instanceof FileAlreadyExistsException)) {
                shouldThrowException = false;
            }
            if (shouldThrowException) {
                validationErrStr = validationErrStr + ioe.getMessage();
                throw new VisitorException(store, validationErrStr, errCode, errSrc, ioe);
            }
        }
        catch (InterruptedException ie) {
            validationErrStr = validationErrStr + ie.getMessage();
            throw new VisitorException(store, validationErrStr, errCode, this.pigCtx.getErrorSource(), ie);
        }
    }
}

