/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.optimizer.AllSameRalationalNodesVisitor;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.optimizer.UidResetter;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

public class ImplicitSplitInsertVisitor
extends AllSameRalationalNodesVisitor {
    public ImplicitSplitInsertVisitor(LogicalPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    private boolean nodeHasTwoOutputs(LogicalRelationalOperator op) {
        if (op instanceof LOSplit || op instanceof LOStore) {
            return false;
        }
        List<Operator> succs = this.plan.getSuccessors(op);
        return succs != null && succs.size() >= 2;
    }

    public void execute(LogicalRelationalOperator op) throws FrontendException {
        if (!this.nodeHasTwoOutputs(op)) {
            return;
        }
        List<Operator> succs = this.plan.getSuccessors(op);
        if (succs == null || succs.size() < 2) {
            throw new FrontendException("Invalid match in ImplicitSplitInserter rule.", 2243);
        }
        LOSplit splitOp = new LOSplit(this.plan);
        splitOp.setAlias(op.getAlias());
        Operator[] sucs = succs.toArray(new Operator[0]);
        this.plan.add(splitOp);
        this.plan.connect(op, splitOp);
        for (Operator suc : sucs) {
            Pair<Integer, Integer> pos = this.plan.disconnect(op, suc);
            LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
            new ConstantExpression(filterPlan, true);
            LOSplitOutput splitOutput = new LOSplitOutput((LogicalPlan)this.plan, filterPlan);
            splitOutput.setAlias(splitOp.getAlias());
            this.plan.add(splitOutput);
            this.plan.connect(splitOp, splitOutput);
            this.plan.connect(splitOutput, (Integer)pos.first, suc, (Integer)pos.second);
        }
        UidResetter uidResetter = new UidResetter(this.plan);
        uidResetter.visit();
        SchemaResetter schemaResetter = new SchemaResetter(this.plan, true);
        schemaResetter.visit();
    }
}

