/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NegativeExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;

class ConstExpEvaluator
extends LogicalExpressionVisitor {
    Deque<ConstantExpression> result = new LinkedList<ConstantExpression>();

    ConstExpEvaluator(OperatorPlan plan) throws FrontendException {
        super(plan, new ReverseDependencyOrderWalker(plan));
    }

    private void binaryExpressionConstPrune(LogicalExpression parent) throws FrontendException {
        block46: {
            ConstantExpression newExp;
            ConstantExpression lhs;
            ConstantExpression rhs;
            block48: {
                block59: {
                    byte type;
                    block58: {
                        block57: {
                            block56: {
                                block55: {
                                    block54: {
                                        block53: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block49: {
                                                            block47: {
                                                                block45: {
                                                                    rhs = this.result.pop();
                                                                    lhs = this.result.pop();
                                                                    if (rhs != null && lhs != null) break block45;
                                                                    this.result.push(null);
                                                                    break block46;
                                                                }
                                                                newExp = null;
                                                                if (!(parent instanceof AndExpression)) break block47;
                                                                newExp = new ConstantExpression(this.plan, (Boolean)rhs.getValue() != false && (Boolean)lhs.getValue() != false);
                                                                break block48;
                                                            }
                                                            if (!(parent instanceof OrExpression)) break block49;
                                                            newExp = new ConstantExpression(this.plan, (Boolean)rhs.getValue() != false || (Boolean)lhs.getValue() != false);
                                                            break block48;
                                                        }
                                                        if (!(parent instanceof EqualExpression)) break block50;
                                                        newExp = new ConstantExpression(this.plan, rhs.isEqual(lhs));
                                                        break block48;
                                                    }
                                                    if (!(parent instanceof GreaterThanExpression)) break block51;
                                                    newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) > 0);
                                                    break block48;
                                                }
                                                if (!(parent instanceof GreaterThanEqualExpression)) break block52;
                                                newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) >= 0);
                                                break block48;
                                            }
                                            if (!(parent instanceof LessThanExpression)) break block53;
                                            newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) < 0);
                                            break block48;
                                        }
                                        if (!(parent instanceof LessThanExpression)) break block54;
                                        newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) <= 0);
                                        break block48;
                                    }
                                    if (!(parent instanceof AddExpression)) break block55;
                                    type = parent.getFieldSchema().type;
                                    switch (type) {
                                        case 10: {
                                            newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() + (Integer)rhs.getValue());
                                            break;
                                        }
                                        case 15: {
                                            newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() + (Long)rhs.getValue());
                                            break;
                                        }
                                        case 20: {
                                            newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() + ((Float)rhs.getValue()).floatValue()));
                                            break;
                                        }
                                        case 25: {
                                            newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() + (Double)rhs.getValue());
                                            break;
                                        }
                                        case 65: {
                                            newExp = new ConstantExpression(this.plan, ((BigInteger)lhs.getValue()).add((BigInteger)rhs.getValue()));
                                            break;
                                        }
                                        case 70: {
                                            newExp = new ConstantExpression(this.plan, ((BigDecimal)lhs.getValue()).add((BigDecimal)rhs.getValue()));
                                            break;
                                        }
                                        default: {
                                            throw new FrontendException("Invalid type");
                                        }
                                    }
                                    break block48;
                                }
                                if (!(parent instanceof SubtractExpression)) break block56;
                                type = parent.getFieldSchema().type;
                                switch (type) {
                                    case 10: {
                                        newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() - (Integer)rhs.getValue());
                                        break;
                                    }
                                    case 15: {
                                        newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() - (Long)rhs.getValue());
                                        break;
                                    }
                                    case 20: {
                                        newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() - ((Float)rhs.getValue()).floatValue()));
                                        break;
                                    }
                                    case 25: {
                                        newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() - (Double)rhs.getValue());
                                        break;
                                    }
                                    case 65: {
                                        newExp = new ConstantExpression(this.plan, ((BigInteger)lhs.getValue()).subtract((BigInteger)rhs.getValue()));
                                        break;
                                    }
                                    case 70: {
                                        newExp = new ConstantExpression(this.plan, ((BigDecimal)lhs.getValue()).subtract((BigDecimal)rhs.getValue()));
                                        break;
                                    }
                                    default: {
                                        throw new FrontendException("Invalid type");
                                    }
                                }
                                break block48;
                            }
                            if (!(parent instanceof MultiplyExpression)) break block57;
                            type = parent.getFieldSchema().type;
                            switch (type) {
                                case 10: {
                                    newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() * (Integer)rhs.getValue());
                                    break;
                                }
                                case 15: {
                                    newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() * (Long)rhs.getValue());
                                    break;
                                }
                                case 20: {
                                    newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() * ((Float)rhs.getValue()).floatValue()));
                                    break;
                                }
                                case 25: {
                                    newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() * (Double)rhs.getValue());
                                    break;
                                }
                                case 65: {
                                    newExp = new ConstantExpression(this.plan, ((BigInteger)lhs.getValue()).multiply((BigInteger)rhs.getValue()));
                                    break;
                                }
                                case 70: {
                                    newExp = new ConstantExpression(this.plan, ((BigDecimal)lhs.getValue()).multiply((BigDecimal)rhs.getValue()));
                                    break;
                                }
                                default: {
                                    throw new FrontendException("Invalid type");
                                }
                            }
                            break block48;
                        }
                        if (!(parent instanceof ModExpression)) break block58;
                        type = parent.getFieldSchema().type;
                        switch (type) {
                            case 10: {
                                newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() % (Integer)rhs.getValue());
                                break;
                            }
                            case 15: {
                                newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() % (Long)rhs.getValue());
                                break;
                            }
                            case 65: {
                                newExp = new ConstantExpression(this.plan, ((BigInteger)lhs.getValue()).mod((BigInteger)rhs.getValue()));
                                break;
                            }
                            default: {
                                throw new FrontendException("Invalid type");
                            }
                        }
                        break block48;
                    }
                    if (!(parent instanceof DivideExpression)) break block59;
                    type = parent.getFieldSchema().type;
                    switch (type) {
                        case 10: {
                            if ((Integer)rhs.getValue() != 0) {
                                newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() / (Integer)rhs.getValue());
                                break;
                            }
                            break block48;
                        }
                        case 15: {
                            if ((Long)rhs.getValue() != 0L) {
                                newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() / (Long)rhs.getValue());
                                break;
                            }
                            break block48;
                        }
                        case 20: {
                            if (((Float)rhs.getValue()).floatValue() != 0.0f) {
                                newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() / ((Float)rhs.getValue()).floatValue()));
                                break;
                            }
                            break block48;
                        }
                        case 25: {
                            if ((Double)rhs.getValue() != 0.0) {
                                newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() / (Double)rhs.getValue());
                                break;
                            }
                            break block48;
                        }
                        case 65: {
                            newExp = new ConstantExpression(this.plan, ((BigInteger)lhs.getValue()).divide((BigInteger)rhs.getValue()));
                            break;
                        }
                        case 70: {
                            newExp = new ConstantExpression(this.plan, ((BigDecimal)lhs.getValue()).divide((BigDecimal)rhs.getValue()));
                            break;
                        }
                        default: {
                            throw new FrontendException("Invalid type");
                        }
                    }
                    break block48;
                }
                throw new FrontendException("Invalid instance type.");
            }
            if (newExp != null) {
                this.plan.disconnect(parent, rhs);
                this.plan.remove(rhs);
                this.plan.disconnect(parent, lhs);
                this.plan.remove(lhs);
                this.plan.add(newExp);
                List<Operator> predList = this.plan.getPredecessors(parent);
                if (predList != null) {
                    Operator[] preds;
                    Operator[] arr$ = preds = predList.toArray(new Operator[0]);
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Operator p;
                        Operator pred = p = arr$[i$];
                        Pair<Integer, Integer> pos = this.plan.disconnect(pred, parent);
                        this.plan.connect(pred, (Integer)pos.first, newExp, (Integer)pos.second);
                    }
                }
                this.plan.remove(parent);
                this.result.push(newExp);
            } else {
                this.result.push(null);
            }
        }
    }

    private void unaryExpressionConstPrune(LogicalExpression op) throws FrontendException {
        ConstantExpression operand = this.result.pop();
        if (operand == null) {
            this.result.push(null);
            return;
        }
        if (op instanceof CastExpression) {
            this.result.push(null);
        } else {
            ConstantExpression newExp;
            this.plan.remove(operand);
            this.plan.remove(op);
            if (op instanceof NotExpression) {
                newExp = new ConstantExpression(this.plan, (Boolean)operand.getValue() == false);
            } else if (op instanceof IsNullExpression) {
                newExp = new ConstantExpression(this.plan, operand.getValue() == null);
            } else if (op instanceof NegativeExpression) {
                byte type = operand.getFieldSchema().type;
                switch (type) {
                    case 10: {
                        newExp = new ConstantExpression(this.plan, -1 * (Integer)operand.getValue());
                        break;
                    }
                    case 15: {
                        newExp = new ConstantExpression(this.plan, -1L * (Long)operand.getValue());
                        break;
                    }
                    case 20: {
                        newExp = new ConstantExpression(this.plan, Float.valueOf(-1.0f * ((Float)operand.getValue()).floatValue()));
                        break;
                    }
                    case 25: {
                        newExp = new ConstantExpression(this.plan, -1.0 * (double)((Integer)operand.getValue()).intValue());
                        break;
                    }
                    case 65: {
                        newExp = new ConstantExpression(this.plan, ((BigInteger)operand.getValue()).negate());
                        break;
                    }
                    case 70: {
                        newExp = new ConstantExpression(this.plan, ((BigDecimal)operand.getValue()).negate());
                        break;
                    }
                    default: {
                        throw new FrontendException("Invalid type");
                    }
                }
            } else {
                throw new FrontendException("Invalid instance type.");
            }
            this.plan.add(newExp);
            this.result.push(newExp);
        }
    }

    private void noConstPrune(LogicalExpression op) throws FrontendException {
        List<Operator> sucs = op.getPlan().getSuccessors(op);
        int nSucs = sucs == null ? 0 : sucs.size();
        for (int i = 0; i < nSucs; ++i) {
            this.result.pop();
        }
        this.result.push(null);
    }

    public void visit(ConstantExpression constant) throws FrontendException {
        this.result.push(constant);
    }

    public void visit(AndExpression andExpr) throws FrontendException {
        this.binaryExpressionConstPrune(andExpr);
    }

    public void visit(OrExpression orExpr) throws FrontendException {
        this.binaryExpressionConstPrune(orExpr);
    }

    public void visit(EqualExpression equal) throws FrontendException {
        this.binaryExpressionConstPrune(equal);
    }

    public void visit(ProjectExpression project) throws FrontendException {
        this.noConstPrune(project);
    }

    public void visit(CastExpression cast) throws FrontendException {
        this.unaryExpressionConstPrune(cast);
    }

    public void visit(GreaterThanExpression greaterThanExpression) throws FrontendException {
        this.binaryExpressionConstPrune(greaterThanExpression);
    }

    public void visit(NotExpression op) throws FrontendException {
        this.unaryExpressionConstPrune(op);
    }

    public void visit(IsNullExpression op) throws FrontendException {
        this.unaryExpressionConstPrune(op);
    }

    public void visit(NegativeExpression op) throws FrontendException {
        this.unaryExpressionConstPrune(op);
    }

    public void visit(AddExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    public void visit(SubtractExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    public void visit(ModExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    public void visit(MultiplyExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    public void visit(DivideExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    public void visit(MapLookupExpression op) throws FrontendException {
        this.noConstPrune(op);
    }

    public void visit(BinCondExpression op) throws FrontendException {
        this.noConstPrune(op);
    }

    public void visit(UserFuncExpression op) throws FrontendException {
        this.noConstPrune(op);
    }

    public void visit(DereferenceExpression bagDerefenceExpression) throws FrontendException {
        this.noConstPrune(bagDerefenceExpression);
    }

    public void visit(RegexExpression op) throws FrontendException {
        this.noConstPrune(op);
    }
}

