/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalRelationalOperator
extends Operator {
    protected LogicalSchema schema;
    protected int requestedParallelism;
    protected String alias;
    protected int lineNum;
    protected String mCustomPartitioner = null;
    protected HashSet<Integer> mPinnedOptions = new HashSet();

    public LogicalRelationalOperator(String name, OperatorPlan plan) {
        this(name, plan, -1);
    }

    public LogicalRelationalOperator(String name, OperatorPlan plan, int rp) {
        super(name, plan);
        this.requestedParallelism = rp;
    }

    public abstract LogicalSchema getSchema() throws FrontendException;

    public void setSchema(LogicalSchema schema) {
        this.schema = schema;
    }

    public void resetSchema() {
        this.schema = null;
    }

    public void resetUid() {
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setRequestedParallelism(int parallel) {
        this.requestedParallelism = parallel;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public void neverUseForRealSetSchema(LogicalSchema schema) {
        this.schema = schema;
    }

    protected boolean checkEquality(LogicalRelationalOperator other) throws FrontendException {
        if (other == null) {
            return false;
        }
        LogicalSchema s = this.getSchema();
        LogicalSchema os = other.getSchema();
        if (s != null || os != null) {
            if (s == null || os == null) {
                return false;
            }
            if (!s.isEqual(os)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.alias != null) {
            msg.append(this.alias + ": ");
        }
        msg.append("(Name: " + this.getName() + " Schema: ");
        if (this.schema != null) {
            msg.append(this.schema);
        } else {
            msg.append("null");
        }
        msg.append(")");
        if (this.annotations != null) {
            for (Map.Entry entry : this.annotations.entrySet()) {
                msg.append(entry);
            }
        }
        return msg.toString();
    }

    public String getCustomPartitioner() {
        return this.mCustomPartitioner;
    }

    public void setCustomPartitioner(String customPartitioner) {
        this.mCustomPartitioner = customPartitioner;
    }

    public void pinOption(Integer opt) {
        this.mPinnedOptions.add(opt);
    }

    public boolean isPinnedOption(Integer opt) {
        return this.mPinnedOptions.contains(opt);
    }

    private static void addFieldSchemaUidsToSet(Set<Long> uids, LogicalSchema.LogicalFieldSchema lfs) {
        while (!uids.add(lfs.uid)) {
            lfs.uid = LogicalExpression.getNextUid();
        }
        LogicalSchema ls = lfs.schema;
        if (ls != null) {
            for (LogicalSchema.LogicalFieldSchema lfs2 : ls.getFields()) {
                LogicalRelationalOperator.addFieldSchemaUidsToSet(uids, lfs2);
            }
        }
    }

    public static void fixDuplicateUids(List<LogicalSchema.LogicalFieldSchema> fss) {
        HashSet uids = Sets.newHashSet();
        for (LogicalSchema.LogicalFieldSchema lfs : fss) {
            LogicalRelationalOperator.addFieldSchemaUidsToSet(uids, lfs);
        }
    }
}

